package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveBatchTaskForApplyQuickTransferOutOpenly invokes the domain.SaveBatchTaskForApplyQuickTransferOutOpenly API synchronously
func (client *Client) SaveBatchTaskForApplyQuickTransferOutOpenly(request *SaveBatchTaskForApplyQuickTransferOutOpenlyRequest) (response *SaveBatchTaskForApplyQuickTransferOutOpenlyResponse, err error) {
	response = CreateSaveBatchTaskForApplyQuickTransferOutOpenlyResponse()
	err = client.DoAction(request, response)
	return
}

// SaveBatchTaskForApplyQuickTransferOutOpenlyWithChan invokes the domain.SaveBatchTaskForApplyQuickTransferOutOpenly API asynchronously
func (client *Client) SaveBatchTaskForApplyQuickTransferOutOpenlyWithChan(request *SaveBatchTaskForApplyQuickTransferOutOpenlyRequest) (<-chan *SaveBatchTaskForApplyQuickTransferOutOpenlyResponse, <-chan error) {
	responseChan := make(chan *SaveBatchTaskForApplyQuickTransferOutOpenlyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveBatchTaskForApplyQuickTransferOutOpenly(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveBatchTaskForApplyQuickTransferOutOpenlyWithCallback invokes the domain.SaveBatchTaskForApplyQuickTransferOutOpenly API asynchronously
func (client *Client) SaveBatchTaskForApplyQuickTransferOutOpenlyWithCallback(request *SaveBatchTaskForApplyQuickTransferOutOpenlyRequest, callback func(response *SaveBatchTaskForApplyQuickTransferOutOpenlyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveBatchTaskForApplyQuickTransferOutOpenlyResponse
		var err error
		defer close(result)
		response, err = client.SaveBatchTaskForApplyQuickTransferOutOpenly(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveBatchTaskForApplyQuickTransferOutOpenlyRequest is the request struct for api SaveBatchTaskForApplyQuickTransferOutOpenly
type SaveBatchTaskForApplyQuickTransferOutOpenlyRequest struct {
	*requests.RpcRequest
	DomainNames  *[]string `position:"Query" name:"DomainNames"  type:"Repeated"`
	UserClientIp string    `position:"Query" name:"UserClientIp"`
	Lang         string    `position:"Query" name:"Lang"`
}

// SaveBatchTaskForApplyQuickTransferOutOpenlyResponse is the response struct for api SaveBatchTaskForApplyQuickTransferOutOpenly
type SaveBatchTaskForApplyQuickTransferOutOpenlyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskNo    string `json:"TaskNo" xml:"TaskNo"`
}

// CreateSaveBatchTaskForApplyQuickTransferOutOpenlyRequest creates a request to invoke SaveBatchTaskForApplyQuickTransferOutOpenly API
func CreateSaveBatchTaskForApplyQuickTransferOutOpenlyRequest() (request *SaveBatchTaskForApplyQuickTransferOutOpenlyRequest) {
	request = &SaveBatchTaskForApplyQuickTransferOutOpenlyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "SaveBatchTaskForApplyQuickTransferOutOpenly", "domain", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSaveBatchTaskForApplyQuickTransferOutOpenlyResponse creates a response to parse from SaveBatchTaskForApplyQuickTransferOutOpenly response
func CreateSaveBatchTaskForApplyQuickTransferOutOpenlyResponse() (response *SaveBatchTaskForApplyQuickTransferOutOpenlyResponse) {
	response = &SaveBatchTaskForApplyQuickTransferOutOpenlyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
