package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSmsSign invokes the dysmsapi.GetSmsSign API synchronously
func (client *Client) GetSmsSign(request *GetSmsSignRequest) (response *GetSmsSignResponse, err error) {
	response = CreateGetSmsSignResponse()
	err = client.DoAction(request, response)
	return
}

// GetSmsSignWithChan invokes the dysmsapi.GetSmsSign API asynchronously
func (client *Client) GetSmsSignWithChan(request *GetSmsSignRequest) (<-chan *GetSmsSignResponse, <-chan error) {
	responseChan := make(chan *GetSmsSignResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSmsSign(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSmsSignWithCallback invokes the dysmsapi.GetSmsSign API asynchronously
func (client *Client) GetSmsSignWithCallback(request *GetSmsSignRequest, callback func(response *GetSmsSignResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSmsSignResponse
		var err error
		defer close(result)
		response, err = client.GetSmsSign(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSmsSignRequest is the request struct for api GetSmsSign
type GetSmsSignRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ExtendFunction       string           `position:"Query" name:"ExtendFunction"`
	SignName             string           `position:"Query" name:"SignName"`
	RouteName            string           `position:"Query" name:"RouteName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ProdCode             string           `position:"Query" name:"ProdCode"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// GetSmsSignResponse is the response struct for api GetSmsSign
type GetSmsSignResponse struct {
	*responses.BaseResponse
	RequestId       string    `json:"RequestId" xml:"RequestId"`
	Code            string    `json:"Code" xml:"Code"`
	Message         string    `json:"Message" xml:"Message"`
	SignName        string    `json:"SignName" xml:"SignName"`
	SignStatus      int64     `json:"SignStatus" xml:"SignStatus"`
	CreateDate      string    `json:"CreateDate" xml:"CreateDate"`
	OrderId         string    `json:"OrderId" xml:"OrderId"`
	QualificationId int64     `json:"QualificationId" xml:"QualificationId"`
	Remark          string    `json:"Remark" xml:"Remark"`
	SignCode        string    `json:"SignCode" xml:"SignCode"`
	SignTag         string    `json:"SignTag" xml:"SignTag"`
	ApplyScene      string    `json:"ApplyScene" xml:"ApplyScene"`
	ThirdParty      bool      `json:"ThirdParty" xml:"ThirdParty"`
	SignUsage       string    `json:"SignUsage" xml:"SignUsage"`
	RegisterResult  int       `json:"RegisterResult" xml:"RegisterResult"`
	FileUrlList     []string  `json:"FileUrlList" xml:"FileUrlList"`
	AuditInfo       AuditInfo `json:"AuditInfo" xml:"AuditInfo"`
}

// CreateGetSmsSignRequest creates a request to invoke GetSmsSign API
func CreateGetSmsSignRequest() (request *GetSmsSignRequest) {
	request = &GetSmsSignRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "GetSmsSign", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSmsSignResponse creates a response to parse from GetSmsSign response
func CreateGetSmsSignResponse() (response *GetSmsSignResponse) {
	response = &GetSmsSignResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
