package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDedicatedBlockStorageClusters invokes the ebs.DescribeDedicatedBlockStorageClusters API synchronously
func (client *Client) DescribeDedicatedBlockStorageClusters(request *DescribeDedicatedBlockStorageClustersRequest) (response *DescribeDedicatedBlockStorageClustersResponse, err error) {
	response = CreateDescribeDedicatedBlockStorageClustersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDedicatedBlockStorageClustersWithChan invokes the ebs.DescribeDedicatedBlockStorageClusters API asynchronously
func (client *Client) DescribeDedicatedBlockStorageClustersWithChan(request *DescribeDedicatedBlockStorageClustersRequest) (<-chan *DescribeDedicatedBlockStorageClustersResponse, <-chan error) {
	responseChan := make(chan *DescribeDedicatedBlockStorageClustersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDedicatedBlockStorageClusters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDedicatedBlockStorageClustersWithCallback invokes the ebs.DescribeDedicatedBlockStorageClusters API asynchronously
func (client *Client) DescribeDedicatedBlockStorageClustersWithCallback(request *DescribeDedicatedBlockStorageClustersRequest, callback func(response *DescribeDedicatedBlockStorageClustersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDedicatedBlockStorageClustersResponse
		var err error
		defer close(result)
		response, err = client.DescribeDedicatedBlockStorageClusters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDedicatedBlockStorageClustersRequest is the request struct for api DescribeDedicatedBlockStorageClusters
type DescribeDedicatedBlockStorageClustersRequest struct {
	*requests.RpcRequest
	ClientToken                    string                                      `position:"Body" name:"ClientToken"`
	PageNumber                     requests.Integer                            `position:"Query" name:"PageNumber"`
	ResourceGroupId                string                                      `position:"Query" name:"ResourceGroupId"`
	AzoneId                        string                                      `position:"Body" name:"AzoneId"`
	NextToken                      string                                      `position:"Body" name:"NextToken"`
	PageSize                       requests.Integer                            `position:"Query" name:"PageSize"`
	Tag                            *[]DescribeDedicatedBlockStorageClustersTag `position:"Query" name:"Tag"  type:"Repeated"`
	DedicatedBlockStorageClusterId *[]string                                   `position:"Body" name:"DedicatedBlockStorageClusterId"  type:"Repeated"`
	MaxResults                     requests.Integer                            `position:"Body" name:"MaxResults"`
	Category                       string                                      `position:"Body" name:"Category"`
	Status                         *[]string                                   `position:"Body" name:"Status"  type:"Repeated"`
}

// DescribeDedicatedBlockStorageClustersTag is a repeated param struct in DescribeDedicatedBlockStorageClustersRequest
type DescribeDedicatedBlockStorageClustersTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeDedicatedBlockStorageClustersResponse is the response struct for api DescribeDedicatedBlockStorageClusters
type DescribeDedicatedBlockStorageClustersResponse struct {
	*responses.BaseResponse
	RequestId                     string `json:"RequestId" xml:"RequestId"`
	NextToken                     string `json:"NextToken" xml:"NextToken"`
	PageNumber                    int    `json:"PageNumber" xml:"PageNumber"`
	PageSize                      int    `json:"PageSize" xml:"PageSize"`
	TotalCount                    int64  `json:"TotalCount" xml:"TotalCount"`
	DedicatedBlockStorageClusters []Dbsc `json:"DedicatedBlockStorageClusters" xml:"DedicatedBlockStorageClusters"`
}

// CreateDescribeDedicatedBlockStorageClustersRequest creates a request to invoke DescribeDedicatedBlockStorageClusters API
func CreateDescribeDedicatedBlockStorageClustersRequest() (request *DescribeDedicatedBlockStorageClustersRequest) {
	request = &DescribeDedicatedBlockStorageClustersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "DescribeDedicatedBlockStorageClusters", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDedicatedBlockStorageClustersResponse creates a response to parse from DescribeDedicatedBlockStorageClusters response
func CreateDescribeDedicatedBlockStorageClustersResponse() (response *DescribeDedicatedBlockStorageClustersResponse) {
	response = &DescribeDedicatedBlockStorageClustersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
