package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiskReplicaPairs invokes the ebs.DescribeDiskReplicaPairs API synchronously
func (client *Client) DescribeDiskReplicaPairs(request *DescribeDiskReplicaPairsRequest) (response *DescribeDiskReplicaPairsResponse, err error) {
	response = CreateDescribeDiskReplicaPairsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiskReplicaPairsWithChan invokes the ebs.DescribeDiskReplicaPairs API asynchronously
func (client *Client) DescribeDiskReplicaPairsWithChan(request *DescribeDiskReplicaPairsRequest) (<-chan *DescribeDiskReplicaPairsResponse, <-chan error) {
	responseChan := make(chan *DescribeDiskReplicaPairsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiskReplicaPairs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiskReplicaPairsWithCallback invokes the ebs.DescribeDiskReplicaPairs API asynchronously
func (client *Client) DescribeDiskReplicaPairsWithCallback(request *DescribeDiskReplicaPairsRequest, callback func(response *DescribeDiskReplicaPairsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiskReplicaPairsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiskReplicaPairs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiskReplicaPairsRequest is the request struct for api DescribeDiskReplicaPairs
type DescribeDiskReplicaPairsRequest struct {
	*requests.RpcRequest
	PageNumber      requests.Integer               `position:"Query" name:"PageNumber"`
	ResourceGroupId string                         `position:"Query" name:"ResourceGroupId"`
	NextToken       string                         `position:"Query" name:"NextToken"`
	PageSize        requests.Integer               `position:"Query" name:"PageSize"`
	Tag             *[]DescribeDiskReplicaPairsTag `position:"Query" name:"Tag"  type:"Repeated"`
	PairIds         string                         `position:"Query" name:"PairIds"`
	ReplicaGroupId  string                         `position:"Query" name:"ReplicaGroupId"`
	Site            string                         `position:"Query" name:"Site"`
	MaxResults      requests.Integer               `position:"Query" name:"MaxResults"`
}

// DescribeDiskReplicaPairsTag is a repeated param struct in DescribeDiskReplicaPairsRequest
type DescribeDiskReplicaPairsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeDiskReplicaPairsResponse is the response struct for api DescribeDiskReplicaPairs
type DescribeDiskReplicaPairsResponse struct {
	*responses.BaseResponse
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	NextToken    string        `json:"NextToken" xml:"NextToken"`
	PageNumber   int           `json:"PageNumber" xml:"PageNumber"`
	PageSize     int           `json:"PageSize" xml:"PageSize"`
	TotalCount   int64         `json:"TotalCount" xml:"TotalCount"`
	ReplicaPairs []ReplicaPair `json:"ReplicaPairs" xml:"ReplicaPairs"`
}

// CreateDescribeDiskReplicaPairsRequest creates a request to invoke DescribeDiskReplicaPairs API
func CreateDescribeDiskReplicaPairsRequest() (request *DescribeDiskReplicaPairsRequest) {
	request = &DescribeDiskReplicaPairsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "DescribeDiskReplicaPairs", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDiskReplicaPairsResponse creates a response to parse from DescribeDiskReplicaPairs response
func CreateDescribeDiskReplicaPairsResponse() (response *DescribeDiskReplicaPairsResponse) {
	response = &DescribeDiskReplicaPairsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
