package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDevices invokes the ecd.DeleteDevices API synchronously
func (client *Client) DeleteDevices(request *DeleteDevicesRequest) (response *DeleteDevicesResponse, err error) {
	response = CreateDeleteDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDevicesWithChan invokes the ecd.DeleteDevices API asynchronously
func (client *Client) DeleteDevicesWithChan(request *DeleteDevicesRequest) (<-chan *DeleteDevicesResponse, <-chan error) {
	responseChan := make(chan *DeleteDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDevicesWithCallback invokes the ecd.DeleteDevices API asynchronously
func (client *Client) DeleteDevicesWithCallback(request *DeleteDevicesRequest, callback func(response *DeleteDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDevicesResponse
		var err error
		defer close(result)
		response, err = client.DeleteDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDevicesRequest is the request struct for api DeleteDevices
type DeleteDevicesRequest struct {
	*requests.RpcRequest
	ClientType requests.Integer `position:"Query" name:"ClientType"`
	DeviceIds  *[]string        `position:"Query" name:"DeviceIds"  type:"Repeated"`
	Force      requests.Integer `position:"Query" name:"Force"`
}

// DeleteDevicesResponse is the response struct for api DeleteDevices
type DeleteDevicesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDevicesRequest creates a request to invoke DeleteDevices API
func CreateDeleteDevicesRequest() (request *DeleteDevicesRequest) {
	request = &DeleteDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DeleteDevices", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDevicesResponse creates a response to parse from DeleteDevices response
func CreateDeleteDevicesResponse() (response *DeleteDevicesResponse) {
	response = &DeleteDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
