package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeKmsKeys invokes the ecd.DescribeKmsKeys API synchronously
func (client *Client) DescribeKmsKeys(request *DescribeKmsKeysRequest) (response *DescribeKmsKeysResponse, err error) {
	response = CreateDescribeKmsKeysResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeKmsKeysWithChan invokes the ecd.DescribeKmsKeys API asynchronously
func (client *Client) DescribeKmsKeysWithChan(request *DescribeKmsKeysRequest) (<-chan *DescribeKmsKeysResponse, <-chan error) {
	responseChan := make(chan *DescribeKmsKeysResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeKmsKeys(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeKmsKeysWithCallback invokes the ecd.DescribeKmsKeys API asynchronously
func (client *Client) DescribeKmsKeysWithCallback(request *DescribeKmsKeysRequest, callback func(response *DescribeKmsKeysResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeKmsKeysResponse
		var err error
		defer close(result)
		response, err = client.DescribeKmsKeys(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeKmsKeysRequest is the request struct for api DescribeKmsKeys
type DescribeKmsKeysRequest struct {
	*requests.RpcRequest
}

// DescribeKmsKeysResponse is the response struct for api DescribeKmsKeys
type DescribeKmsKeysResponse struct {
	*responses.BaseResponse
	RequestId        string `json:"RequestId" xml:"RequestId"`
	KmsServiceStatus string `json:"KmsServiceStatus" xml:"KmsServiceStatus"`
	AuthorizeStatus  string `json:"AuthorizeStatus" xml:"AuthorizeStatus"`
	Keys             []Key  `json:"Keys" xml:"Keys"`
}

// CreateDescribeKmsKeysRequest creates a request to invoke DescribeKmsKeys API
func CreateDescribeKmsKeysRequest() (request *DescribeKmsKeysRequest) {
	request = &DescribeKmsKeysRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeKmsKeys", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeKmsKeysResponse creates a response to parse from DescribeKmsKeys response
func CreateDescribeKmsKeysResponse() (response *DescribeKmsKeysResponse) {
	response = &DescribeKmsKeysResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
