package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyAclEntries invokes the ecd.ModifyAclEntries API synchronously
func (client *Client) ModifyAclEntries(request *ModifyAclEntriesRequest) (response *ModifyAclEntriesResponse, err error) {
	response = CreateModifyAclEntriesResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyAclEntriesWithChan invokes the ecd.ModifyAclEntries API asynchronously
func (client *Client) ModifyAclEntriesWithChan(request *ModifyAclEntriesRequest) (<-chan *ModifyAclEntriesResponse, <-chan error) {
	responseChan := make(chan *ModifyAclEntriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyAclEntries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyAclEntriesWithCallback invokes the ecd.ModifyAclEntries API asynchronously
func (client *Client) ModifyAclEntriesWithCallback(request *ModifyAclEntriesRequest, callback func(response *ModifyAclEntriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyAclEntriesResponse
		var err error
		defer close(result)
		response, err = client.ModifyAclEntries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyAclEntriesRequest is the request struct for api ModifyAclEntries
type ModifyAclEntriesRequest struct {
	*requests.RpcRequest
	SourceId   *[]string `position:"Query" name:"SourceId"  type:"Repeated"`
	SourceType string    `position:"Query" name:"SourceType"`
	Policy     string    `position:"Query" name:"Policy"`
}

// ModifyAclEntriesResponse is the response struct for api ModifyAclEntries
type ModifyAclEntriesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyAclEntriesRequest creates a request to invoke ModifyAclEntries API
func CreateModifyAclEntriesRequest() (request *ModifyAclEntriesRequest) {
	request = &ModifyAclEntriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyAclEntries", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyAclEntriesResponse creates a response to parse from ModifyAclEntries response
func CreateModifyAclEntriesResponse() (response *ModifyAclEntriesResponse) {
	response = &ModifyAclEntriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
