package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyOfficeSiteCrossDesktopAccess invokes the ecd.ModifyOfficeSiteCrossDesktopAccess API synchronously
func (client *Client) ModifyOfficeSiteCrossDesktopAccess(request *ModifyOfficeSiteCrossDesktopAccessRequest) (response *ModifyOfficeSiteCrossDesktopAccessResponse, err error) {
	response = CreateModifyOfficeSiteCrossDesktopAccessResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyOfficeSiteCrossDesktopAccessWithChan invokes the ecd.ModifyOfficeSiteCrossDesktopAccess API asynchronously
func (client *Client) ModifyOfficeSiteCrossDesktopAccessWithChan(request *ModifyOfficeSiteCrossDesktopAccessRequest) (<-chan *ModifyOfficeSiteCrossDesktopAccessResponse, <-chan error) {
	responseChan := make(chan *ModifyOfficeSiteCrossDesktopAccessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyOfficeSiteCrossDesktopAccess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyOfficeSiteCrossDesktopAccessWithCallback invokes the ecd.ModifyOfficeSiteCrossDesktopAccess API asynchronously
func (client *Client) ModifyOfficeSiteCrossDesktopAccessWithCallback(request *ModifyOfficeSiteCrossDesktopAccessRequest, callback func(response *ModifyOfficeSiteCrossDesktopAccessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyOfficeSiteCrossDesktopAccessResponse
		var err error
		defer close(result)
		response, err = client.ModifyOfficeSiteCrossDesktopAccess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyOfficeSiteCrossDesktopAccessRequest is the request struct for api ModifyOfficeSiteCrossDesktopAccess
type ModifyOfficeSiteCrossDesktopAccessRequest struct {
	*requests.RpcRequest
	OfficeSiteId             string           `position:"Query" name:"OfficeSiteId"`
	EnableCrossDesktopAccess requests.Boolean `position:"Query" name:"EnableCrossDesktopAccess"`
}

// ModifyOfficeSiteCrossDesktopAccessResponse is the response struct for api ModifyOfficeSiteCrossDesktopAccess
type ModifyOfficeSiteCrossDesktopAccessResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyOfficeSiteCrossDesktopAccessRequest creates a request to invoke ModifyOfficeSiteCrossDesktopAccess API
func CreateModifyOfficeSiteCrossDesktopAccessRequest() (request *ModifyOfficeSiteCrossDesktopAccessRequest) {
	request = &ModifyOfficeSiteCrossDesktopAccessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyOfficeSiteCrossDesktopAccess", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyOfficeSiteCrossDesktopAccessResponse creates a response to parse from ModifyOfficeSiteCrossDesktopAccess response
func CreateModifyOfficeSiteCrossDesktopAccessResponse() (response *ModifyOfficeSiteCrossDesktopAccessResponse) {
	response = &ModifyOfficeSiteCrossDesktopAccessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
