package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVpdRouteEntry invokes the eflo.GetVpdRouteEntry API synchronously
func (client *Client) GetVpdRouteEntry(request *GetVpdRouteEntryRequest) (response *GetVpdRouteEntryResponse, err error) {
	response = CreateGetVpdRouteEntryResponse()
	err = client.DoAction(request, response)
	return
}

// GetVpdRouteEntryWithChan invokes the eflo.GetVpdRouteEntry API asynchronously
func (client *Client) GetVpdRouteEntryWithChan(request *GetVpdRouteEntryRequest) (<-chan *GetVpdRouteEntryResponse, <-chan error) {
	responseChan := make(chan *GetVpdRouteEntryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVpdRouteEntry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVpdRouteEntryWithCallback invokes the eflo.GetVpdRouteEntry API asynchronously
func (client *Client) GetVpdRouteEntryWithCallback(request *GetVpdRouteEntryRequest, callback func(response *GetVpdRouteEntryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVpdRouteEntryResponse
		var err error
		defer close(result)
		response, err = client.GetVpdRouteEntry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVpdRouteEntryRequest is the request struct for api GetVpdRouteEntry
type GetVpdRouteEntryRequest struct {
	*requests.RpcRequest
	VpdRouteEntryId string `position:"Body" name:"VpdRouteEntryId"`
	VpdId           string `position:"Body" name:"VpdId"`
}

// GetVpdRouteEntryResponse is the response struct for api GetVpdRouteEntry
type GetVpdRouteEntryResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateGetVpdRouteEntryRequest creates a request to invoke GetVpdRouteEntry API
func CreateGetVpdRouteEntryRequest() (request *GetVpdRouteEntryRequest) {
	request = &GetVpdRouteEntryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "GetVpdRouteEntry", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetVpdRouteEntryResponse creates a response to parse from GetVpdRouteEntry response
func CreateGetVpdRouteEntryResponse() (response *GetVpdRouteEntryResponse) {
	response = &GetVpdRouteEntryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
