package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListErs invokes the eflo.ListErs API synchronously
func (client *Client) ListErs(request *ListErsRequest) (response *ListErsResponse, err error) {
	response = CreateListErsResponse()
	err = client.DoAction(request, response)
	return
}

// ListErsWithChan invokes the eflo.ListErs API asynchronously
func (client *Client) ListErsWithChan(request *ListErsRequest) (<-chan *ListErsResponse, <-chan error) {
	responseChan := make(chan *ListErsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListErs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListErsWithCallback invokes the eflo.ListErs API asynchronously
func (client *Client) ListErsWithCallback(request *ListErsRequest, callback func(response *ListErsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListErsResponse
		var err error
		defer close(result)
		response, err = client.ListErs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListErsRequest is the request struct for api ListErs
type ListErsRequest struct {
	*requests.RpcRequest
	MasterZoneId    string           `position:"Body" name:"MasterZoneId"`
	PageNumber      requests.Integer `position:"Body" name:"PageNumber"`
	ResourceGroupId string           `position:"Body" name:"ResourceGroupId"`
	PageSize        requests.Integer `position:"Body" name:"PageSize"`
	InstanceType    string           `position:"Body" name:"InstanceType"`
	ErId            string           `position:"Body" name:"ErId"`
	ErName          string           `position:"Body" name:"ErName"`
	InstanceId      string           `position:"Body" name:"InstanceId"`
	EnablePage      requests.Boolean `position:"Body" name:"EnablePage"`
}

// ListErsResponse is the response struct for api ListErs
type ListErsResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateListErsRequest creates a request to invoke ListErs API
func CreateListErsRequest() (request *ListErsRequest) {
	request = &ListErsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "ListErs", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListErsResponse creates a response to parse from ListErs response
func CreateListErsResponse() (response *ListErsResponse) {
	response = &ListErsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
