package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DiagnoseInstance invokes the elasticsearch.DiagnoseInstance API synchronously
func (client *Client) DiagnoseInstance(request *DiagnoseInstanceRequest) (response *DiagnoseInstanceResponse, err error) {
	response = CreateDiagnoseInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DiagnoseInstanceWithChan invokes the elasticsearch.DiagnoseInstance API asynchronously
func (client *Client) DiagnoseInstanceWithChan(request *DiagnoseInstanceRequest) (<-chan *DiagnoseInstanceResponse, <-chan error) {
	responseChan := make(chan *DiagnoseInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DiagnoseInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DiagnoseInstanceWithCallback invokes the elasticsearch.DiagnoseInstance API asynchronously
func (client *Client) DiagnoseInstanceWithCallback(request *DiagnoseInstanceRequest, callback func(response *DiagnoseInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DiagnoseInstanceResponse
		var err error
		defer close(result)
		response, err = client.DiagnoseInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DiagnoseInstanceRequest is the request struct for api DiagnoseInstance
type DiagnoseInstanceRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"ClientToken"`
	Lang        string `position:"Query" name:"lang"`
	Body        string `position:"Body" name:"body"`
}

// DiagnoseInstanceResponse is the response struct for api DiagnoseInstance
type DiagnoseInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDiagnoseInstanceRequest creates a request to invoke DiagnoseInstance API
func CreateDiagnoseInstanceRequest() (request *DiagnoseInstanceRequest) {
	request = &DiagnoseInstanceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "DiagnoseInstance", "/openapi/diagnosis/instances/[InstanceId]/actions/diagnose", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDiagnoseInstanceResponse creates a response to parse from DiagnoseInstance response
func CreateDiagnoseInstanceResponse() (response *DiagnoseInstanceResponse) {
	response = &DiagnoseInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
