package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLoadBalancerListenMonitor invokes the ens.DescribeLoadBalancerListenMonitor API synchronously
func (client *Client) DescribeLoadBalancerListenMonitor(request *DescribeLoadBalancerListenMonitorRequest) (response *DescribeLoadBalancerListenMonitorResponse, err error) {
	response = CreateDescribeLoadBalancerListenMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLoadBalancerListenMonitorWithChan invokes the ens.DescribeLoadBalancerListenMonitor API asynchronously
func (client *Client) DescribeLoadBalancerListenMonitorWithChan(request *DescribeLoadBalancerListenMonitorRequest) (<-chan *DescribeLoadBalancerListenMonitorResponse, <-chan error) {
	responseChan := make(chan *DescribeLoadBalancerListenMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLoadBalancerListenMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLoadBalancerListenMonitorWithCallback invokes the ens.DescribeLoadBalancerListenMonitor API asynchronously
func (client *Client) DescribeLoadBalancerListenMonitorWithCallback(request *DescribeLoadBalancerListenMonitorRequest, callback func(response *DescribeLoadBalancerListenMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLoadBalancerListenMonitorResponse
		var err error
		defer close(result)
		response, err = client.DescribeLoadBalancerListenMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLoadBalancerListenMonitorRequest is the request struct for api DescribeLoadBalancerListenMonitor
type DescribeLoadBalancerListenMonitorRequest struct {
	*requests.RpcRequest
	StartTime      string `position:"Query" name:"StartTime"`
	LoadBalancerId string `position:"Query" name:"LoadBalancerId"`
	Proto          string `position:"Query" name:"Proto"`
	VPort          string `position:"Query" name:"VPort"`
	EndTime        string `position:"Query" name:"EndTime"`
}

// DescribeLoadBalancerListenMonitorResponse is the response struct for api DescribeLoadBalancerListenMonitor
type DescribeLoadBalancerListenMonitorResponse struct {
	*responses.BaseResponse
	RequestId                     string                 `json:"RequestId" xml:"RequestId"`
	LoadBalancerMonitorListenData []ElbListenMonitorList `json:"LoadBalancerMonitorListenData" xml:"LoadBalancerMonitorListenData"`
}

// CreateDescribeLoadBalancerListenMonitorRequest creates a request to invoke DescribeLoadBalancerListenMonitor API
func CreateDescribeLoadBalancerListenMonitorRequest() (request *DescribeLoadBalancerListenMonitorRequest) {
	request = &DescribeLoadBalancerListenMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeLoadBalancerListenMonitor", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeLoadBalancerListenMonitorResponse creates a response to parse from DescribeLoadBalancerListenMonitor response
func CreateDescribeLoadBalancerListenMonitorResponse() (response *DescribeLoadBalancerListenMonitorResponse) {
	response = &DescribeLoadBalancerListenMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
