package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableRule invokes the eventbridge.EnableRule API synchronously
func (client *Client) EnableRule(request *EnableRuleRequest) (response *EnableRuleResponse, err error) {
	response = CreateEnableRuleResponse()
	err = client.DoAction(request, response)
	return
}

// EnableRuleWithChan invokes the eventbridge.EnableRule API asynchronously
func (client *Client) EnableRuleWithChan(request *EnableRuleRequest) (<-chan *EnableRuleResponse, <-chan error) {
	responseChan := make(chan *EnableRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableRuleWithCallback invokes the eventbridge.EnableRule API asynchronously
func (client *Client) EnableRuleWithCallback(request *EnableRuleRequest, callback func(response *EnableRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableRuleResponse
		var err error
		defer close(result)
		response, err = client.EnableRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableRuleRequest is the request struct for api EnableRule
type EnableRuleRequest struct {
	*requests.RpcRequest
	RuleName     string `position:"Query" name:"RuleName"`
	EventBusName string `position:"Query" name:"EventBusName"`
}

// EnableRuleResponse is the response struct for api EnableRule
type EnableRuleResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateEnableRuleRequest creates a request to invoke EnableRule API
func CreateEnableRuleRequest() (request *EnableRuleRequest) {
	request = &EnableRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "EnableRule", "", "")
	request.Method = requests.POST
	return
}

// CreateEnableRuleResponse creates a response to parse from EnableRule response
func CreateEnableRuleResponse() (response *EnableRuleResponse) {
	response = &EnableRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
