package ft

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateIns invokes the ft.UpdateIns API synchronously
func (client *Client) UpdateIns(request *UpdateInsRequest) (response *UpdateInsResponse, err error) {
	response = CreateUpdateInsResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateInsWithChan invokes the ft.UpdateIns API asynchronously
func (client *Client) UpdateInsWithChan(request *UpdateInsRequest) (<-chan *UpdateInsResponse, <-chan error) {
	responseChan := make(chan *UpdateInsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateIns(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateInsWithCallback invokes the ft.UpdateIns API asynchronously
func (client *Client) UpdateInsWithCallback(request *UpdateInsRequest, callback func(response *UpdateInsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateInsResponse
		var err error
		defer close(result)
		response, err = client.UpdateIns(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateInsRequest is the request struct for api UpdateIns
type UpdateInsRequest struct {
	*requests.RpcRequest
	Succeed         string `position:"Query" name:"Succeed"`
	HttpStatusCode1 string `position:"Query" name:"HttpStatusCode1"`
}

// UpdateInsResponse is the response struct for api UpdateIns
type UpdateInsResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Success string `json:"Success" xml:"Success"`
}

// CreateUpdateInsRequest creates a request to invoke UpdateIns API
func CreateUpdateInsRequest() (request *UpdateInsRequest) {
	request = &UpdateInsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ft", "2015-03-03", "UpdateIns", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateInsResponse creates a response to parse from UpdateIns response
func CreateUpdateInsResponse() (response *UpdateInsResponse) {
	response = &UpdateInsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
