package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVectorIndex invokes the gpdb.CreateVectorIndex API synchronously
func (client *Client) CreateVectorIndex(request *CreateVectorIndexRequest) (response *CreateVectorIndexResponse, err error) {
	response = CreateCreateVectorIndexResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVectorIndexWithChan invokes the gpdb.CreateVectorIndex API asynchronously
func (client *Client) CreateVectorIndexWithChan(request *CreateVectorIndexRequest) (<-chan *CreateVectorIndexResponse, <-chan error) {
	responseChan := make(chan *CreateVectorIndexResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVectorIndex(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVectorIndexWithCallback invokes the gpdb.CreateVectorIndex API asynchronously
func (client *Client) CreateVectorIndexWithCallback(request *CreateVectorIndexRequest, callback func(response *CreateVectorIndexResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVectorIndexResponse
		var err error
		defer close(result)
		response, err = client.CreateVectorIndex(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVectorIndexRequest is the request struct for api CreateVectorIndex
type CreateVectorIndexRequest struct {
	*requests.RpcRequest
	ManagerAccount         string           `position:"Query" name:"ManagerAccount"`
	DBInstanceId           string           `position:"Query" name:"DBInstanceId"`
	Dimension              requests.Integer `position:"Query" name:"Dimension"`
	ManagerAccountPassword string           `position:"Query" name:"ManagerAccountPassword"`
	Collection             string           `position:"Query" name:"Collection"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
	Namespace              string           `position:"Query" name:"Namespace"`
	Metrics                string           `position:"Query" name:"Metrics"`
}

// CreateVectorIndexResponse is the response struct for api CreateVectorIndex
type CreateVectorIndexResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Status    string `json:"Status" xml:"Status"`
}

// CreateCreateVectorIndexRequest creates a request to invoke CreateVectorIndex API
func CreateCreateVectorIndexRequest() (request *CreateVectorIndexRequest) {
	request = &CreateVectorIndexRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "CreateVectorIndex", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateVectorIndexResponse creates a response to parse from CreateVectorIndex response
func CreateCreateVectorIndexResponse() (response *CreateVectorIndexResponse) {
	response = &CreateVectorIndexResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
