package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInstanceDataBloat invokes the gpdb.DescribeDBInstanceDataBloat API synchronously
func (client *Client) DescribeDBInstanceDataBloat(request *DescribeDBInstanceDataBloatRequest) (response *DescribeDBInstanceDataBloatResponse, err error) {
	response = CreateDescribeDBInstanceDataBloatResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInstanceDataBloatWithChan invokes the gpdb.DescribeDBInstanceDataBloat API asynchronously
func (client *Client) DescribeDBInstanceDataBloatWithChan(request *DescribeDBInstanceDataBloatRequest) (<-chan *DescribeDBInstanceDataBloatResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInstanceDataBloatResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInstanceDataBloat(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInstanceDataBloatWithCallback invokes the gpdb.DescribeDBInstanceDataBloat API asynchronously
func (client *Client) DescribeDBInstanceDataBloatWithCallback(request *DescribeDBInstanceDataBloatRequest, callback func(response *DescribeDBInstanceDataBloatResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInstanceDataBloatResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInstanceDataBloat(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInstanceDataBloatRequest is the request struct for api DescribeDBInstanceDataBloat
type DescribeDBInstanceDataBloatRequest struct {
	*requests.RpcRequest
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	DBInstanceId string           `position:"Query" name:"DBInstanceId"`
}

// DescribeDBInstanceDataBloatResponse is the response struct for api DescribeDBInstanceDataBloat
type DescribeDBInstanceDataBloatResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	TotalCount int         `json:"TotalCount" xml:"TotalCount"`
	PageNumber int         `json:"PageNumber" xml:"PageNumber"`
	Items      []ItemsItem `json:"Items" xml:"Items"`
}

// CreateDescribeDBInstanceDataBloatRequest creates a request to invoke DescribeDBInstanceDataBloat API
func CreateDescribeDBInstanceDataBloatRequest() (request *DescribeDBInstanceDataBloatRequest) {
	request = &DescribeDBInstanceDataBloatRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeDBInstanceDataBloat", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDBInstanceDataBloatResponse creates a response to parse from DescribeDBInstanceDataBloat response
func CreateDescribeDBInstanceDataBloatResponse() (response *DescribeDBInstanceDataBloatResponse) {
	response = &DescribeDBInstanceDataBloatResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
