package gwlb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteServerGroup invokes the gwlb.DeleteServerGroup API synchronously
func (client *Client) DeleteServerGroup(request *DeleteServerGroupRequest) (response *DeleteServerGroupResponse, err error) {
	response = CreateDeleteServerGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteServerGroupWithChan invokes the gwlb.DeleteServerGroup API asynchronously
func (client *Client) DeleteServerGroupWithChan(request *DeleteServerGroupRequest) (<-chan *DeleteServerGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteServerGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteServerGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteServerGroupWithCallback invokes the gwlb.DeleteServerGroup API asynchronously
func (client *Client) DeleteServerGroupWithCallback(request *DeleteServerGroupRequest, callback func(response *DeleteServerGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteServerGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteServerGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteServerGroupRequest is the request struct for api DeleteServerGroup
type DeleteServerGroupRequest struct {
	*requests.RpcRequest
	ClientToken   string           `position:"Body" name:"ClientToken"`
	ServerGroupId string           `position:"Body" name:"ServerGroupId"`
	DryRun        requests.Boolean `position:"Body" name:"DryRun"`
}

// DeleteServerGroupResponse is the response struct for api DeleteServerGroup
type DeleteServerGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteServerGroupRequest creates a request to invoke DeleteServerGroup API
func CreateDeleteServerGroupRequest() (request *DeleteServerGroupRequest) {
	request = &DeleteServerGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Gwlb", "2024-04-15", "DeleteServerGroup", "gwlb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteServerGroupResponse creates a response to parse from DeleteServerGroup response
func CreateDeleteServerGroupResponse() (response *DeleteServerGroupResponse) {
	response = &DeleteServerGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
