package idaas_doraemon

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOrderConsumeStatisticRecords invokes the idaas_doraemon.ListOrderConsumeStatisticRecords API synchronously
func (client *Client) ListOrderConsumeStatisticRecords(request *ListOrderConsumeStatisticRecordsRequest) (response *ListOrderConsumeStatisticRecordsResponse, err error) {
	response = CreateListOrderConsumeStatisticRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// ListOrderConsumeStatisticRecordsWithChan invokes the idaas_doraemon.ListOrderConsumeStatisticRecords API asynchronously
func (client *Client) ListOrderConsumeStatisticRecordsWithChan(request *ListOrderConsumeStatisticRecordsRequest) (<-chan *ListOrderConsumeStatisticRecordsResponse, <-chan error) {
	responseChan := make(chan *ListOrderConsumeStatisticRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOrderConsumeStatisticRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOrderConsumeStatisticRecordsWithCallback invokes the idaas_doraemon.ListOrderConsumeStatisticRecords API asynchronously
func (client *Client) ListOrderConsumeStatisticRecordsWithCallback(request *ListOrderConsumeStatisticRecordsRequest, callback func(response *ListOrderConsumeStatisticRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOrderConsumeStatisticRecordsResponse
		var err error
		defer close(result)
		response, err = client.ListOrderConsumeStatisticRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOrderConsumeStatisticRecordsRequest is the request struct for api ListOrderConsumeStatisticRecords
type ListOrderConsumeStatisticRecordsRequest struct {
	*requests.RpcRequest
	StatisticTimeMin      string           `position:"Query" name:"StatisticTimeMin"`
	AliOrderCode          string           `position:"Query" name:"AliOrderCode"`
	PageNumber            requests.Integer `position:"Query" name:"PageNumber"`
	PageSize              requests.Integer `position:"Query" name:"PageSize"`
	ServiceCode           string           `position:"Query" name:"ServiceCode"`
	StatisticTimeMax      string           `position:"Query" name:"StatisticTimeMax"`
	ApplicationExternalId string           `position:"Query" name:"ApplicationExternalId"`
}

// ListOrderConsumeStatisticRecordsResponse is the response struct for api ListOrderConsumeStatisticRecords
type ListOrderConsumeStatisticRecordsResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	TotalPages    int64  `json:"TotalPages" xml:"TotalPages"`
	TotalElements int64  `json:"TotalElements" xml:"TotalElements"`
	PageSize      int64  `json:"PageSize" xml:"PageSize"`
	Items         []Item `json:"Items" xml:"Items"`
}

// CreateListOrderConsumeStatisticRecordsRequest creates a request to invoke ListOrderConsumeStatisticRecords API
func CreateListOrderConsumeStatisticRecordsRequest() (request *ListOrderConsumeStatisticRecordsRequest) {
	request = &ListOrderConsumeStatisticRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idaas-doraemon", "2021-05-20", "ListOrderConsumeStatisticRecords", "idaasauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListOrderConsumeStatisticRecordsResponse creates a response to parse from ListOrderConsumeStatisticRecords response
func CreateListOrderConsumeStatisticRecordsResponse() (response *ListOrderConsumeStatisticRecordsResponse) {
	response = &ListOrderConsumeStatisticRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
