package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddFingerprintToOIDCProvider invokes the ims.AddFingerprintToOIDCProvider API synchronously
func (client *Client) AddFingerprintToOIDCProvider(request *AddFingerprintToOIDCProviderRequest) (response *AddFingerprintToOIDCProviderResponse, err error) {
	response = CreateAddFingerprintToOIDCProviderResponse()
	err = client.DoAction(request, response)
	return
}

// AddFingerprintToOIDCProviderWithChan invokes the ims.AddFingerprintToOIDCProvider API asynchronously
func (client *Client) AddFingerprintToOIDCProviderWithChan(request *AddFingerprintToOIDCProviderRequest) (<-chan *AddFingerprintToOIDCProviderResponse, <-chan error) {
	responseChan := make(chan *AddFingerprintToOIDCProviderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddFingerprintToOIDCProvider(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddFingerprintToOIDCProviderWithCallback invokes the ims.AddFingerprintToOIDCProvider API asynchronously
func (client *Client) AddFingerprintToOIDCProviderWithCallback(request *AddFingerprintToOIDCProviderRequest, callback func(response *AddFingerprintToOIDCProviderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddFingerprintToOIDCProviderResponse
		var err error
		defer close(result)
		response, err = client.AddFingerprintToOIDCProvider(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddFingerprintToOIDCProviderRequest is the request struct for api AddFingerprintToOIDCProvider
type AddFingerprintToOIDCProviderRequest struct {
	*requests.RpcRequest
	AkProxySuffix    string `position:"Query" name:"AkProxySuffix"`
	OIDCProviderName string `position:"Query" name:"OIDCProviderName"`
	Fingerprint      string `position:"Query" name:"Fingerprint"`
}

// AddFingerprintToOIDCProviderResponse is the response struct for api AddFingerprintToOIDCProvider
type AddFingerprintToOIDCProviderResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	OIDCProvider OIDCProvider `json:"OIDCProvider" xml:"OIDCProvider"`
}

// CreateAddFingerprintToOIDCProviderRequest creates a request to invoke AddFingerprintToOIDCProvider API
func CreateAddFingerprintToOIDCProviderRequest() (request *AddFingerprintToOIDCProviderRequest) {
	request = &AddFingerprintToOIDCProviderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "AddFingerprintToOIDCProvider", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddFingerprintToOIDCProviderResponse creates a response to parse from AddFingerprintToOIDCProvider response
func CreateAddFingerprintToOIDCProviderResponse() (response *AddFingerprintToOIDCProviderResponse) {
	response = &AddFingerprintToOIDCProviderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
