package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLoginProfile invokes the ims.DeleteLoginProfile API synchronously
func (client *Client) DeleteLoginProfile(request *DeleteLoginProfileRequest) (response *DeleteLoginProfileResponse, err error) {
	response = CreateDeleteLoginProfileResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLoginProfileWithChan invokes the ims.DeleteLoginProfile API asynchronously
func (client *Client) DeleteLoginProfileWithChan(request *DeleteLoginProfileRequest) (<-chan *DeleteLoginProfileResponse, <-chan error) {
	responseChan := make(chan *DeleteLoginProfileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLoginProfile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLoginProfileWithCallback invokes the ims.DeleteLoginProfile API asynchronously
func (client *Client) DeleteLoginProfileWithCallback(request *DeleteLoginProfileRequest, callback func(response *DeleteLoginProfileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLoginProfileResponse
		var err error
		defer close(result)
		response, err = client.DeleteLoginProfile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLoginProfileRequest is the request struct for api DeleteLoginProfile
type DeleteLoginProfileRequest struct {
	*requests.RpcRequest
	AkProxySuffix     string `position:"Query" name:"AkProxySuffix"`
	UserPrincipalName string `position:"Query" name:"UserPrincipalName"`
}

// DeleteLoginProfileResponse is the response struct for api DeleteLoginProfile
type DeleteLoginProfileResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLoginProfileRequest creates a request to invoke DeleteLoginProfile API
func CreateDeleteLoginProfileRequest() (request *DeleteLoginProfileRequest) {
	request = &DeleteLoginProfileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "DeleteLoginProfile", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLoginProfileResponse creates a response to parse from DeleteLoginProfile response
func CreateDeleteLoginProfileResponse() (response *DeleteLoginProfileResponse) {
	response = &DeleteLoginProfileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
