package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindGatewayToEdgeInstance invokes the iot.BindGatewayToEdgeInstance API synchronously
func (client *Client) BindGatewayToEdgeInstance(request *BindGatewayToEdgeInstanceRequest) (response *BindGatewayToEdgeInstanceResponse, err error) {
	response = CreateBindGatewayToEdgeInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// BindGatewayToEdgeInstanceWithChan invokes the iot.BindGatewayToEdgeInstance API asynchronously
func (client *Client) BindGatewayToEdgeInstanceWithChan(request *BindGatewayToEdgeInstanceRequest) (<-chan *BindGatewayToEdgeInstanceResponse, <-chan error) {
	responseChan := make(chan *BindGatewayToEdgeInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindGatewayToEdgeInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindGatewayToEdgeInstanceWithCallback invokes the iot.BindGatewayToEdgeInstance API asynchronously
func (client *Client) BindGatewayToEdgeInstanceWithCallback(request *BindGatewayToEdgeInstanceRequest, callback func(response *BindGatewayToEdgeInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindGatewayToEdgeInstanceResponse
		var err error
		defer close(result)
		response, err = client.BindGatewayToEdgeInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindGatewayToEdgeInstanceRequest is the request struct for api BindGatewayToEdgeInstance
type BindGatewayToEdgeInstanceRequest struct {
	*requests.RpcRequest
	IotId         string `position:"Query" name:"IotId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// BindGatewayToEdgeInstanceResponse is the response struct for api BindGatewayToEdgeInstance
type BindGatewayToEdgeInstanceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateBindGatewayToEdgeInstanceRequest creates a request to invoke BindGatewayToEdgeInstance API
func CreateBindGatewayToEdgeInstanceRequest() (request *BindGatewayToEdgeInstanceRequest) {
	request = &BindGatewayToEdgeInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BindGatewayToEdgeInstance", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBindGatewayToEdgeInstanceResponse creates a response to parse from BindGatewayToEdgeInstance response
func CreateBindGatewayToEdgeInstanceResponse() (response *BindGatewayToEdgeInstanceResponse) {
	response = &BindGatewayToEdgeInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
