package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDeviceSpeech invokes the iot.QueryDeviceSpeech API synchronously
func (client *Client) QueryDeviceSpeech(request *QueryDeviceSpeechRequest) (response *QueryDeviceSpeechResponse, err error) {
	response = CreateQueryDeviceSpeechResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDeviceSpeechWithChan invokes the iot.QueryDeviceSpeech API asynchronously
func (client *Client) QueryDeviceSpeechWithChan(request *QueryDeviceSpeechRequest) (<-chan *QueryDeviceSpeechResponse, <-chan error) {
	responseChan := make(chan *QueryDeviceSpeechResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDeviceSpeech(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDeviceSpeechWithCallback invokes the iot.QueryDeviceSpeech API asynchronously
func (client *Client) QueryDeviceSpeechWithCallback(request *QueryDeviceSpeechRequest, callback func(response *QueryDeviceSpeechResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDeviceSpeechResponse
		var err error
		defer close(result)
		response, err = client.QueryDeviceSpeech(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDeviceSpeechRequest is the request struct for api QueryDeviceSpeech
type QueryDeviceSpeechRequest struct {
	*requests.RpcRequest
	PageId        requests.Integer `position:"Body" name:"PageId"`
	IotId         string           `position:"Body" name:"IotId"`
	IotInstanceId string           `position:"Body" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// QueryDeviceSpeechResponse is the response struct for api QueryDeviceSpeech
type QueryDeviceSpeechResponse struct {
	*responses.BaseResponse
	RequestId    string                  `json:"RequestId" xml:"RequestId"`
	Success      bool                    `json:"Success" xml:"Success"`
	Code         string                  `json:"Code" xml:"Code"`
	ErrorMessage string                  `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQueryDeviceSpeech `json:"Data" xml:"Data"`
}

// CreateQueryDeviceSpeechRequest creates a request to invoke QueryDeviceSpeech API
func CreateQueryDeviceSpeechRequest() (request *QueryDeviceSpeechRequest) {
	request = &QueryDeviceSpeechRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryDeviceSpeech", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDeviceSpeechResponse creates a response to parse from QueryDeviceSpeech response
func CreateQueryDeviceSpeechResponse() (response *QueryDeviceSpeechResponse) {
	response = &QueryDeviceSpeechResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
