package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartPTDetection invokes the iot.StartPTDetection API synchronously
func (client *Client) StartPTDetection(request *StartPTDetectionRequest) (response *StartPTDetectionResponse, err error) {
	response = CreateStartPTDetectionResponse()
	err = client.DoAction(request, response)
	return
}

// StartPTDetectionWithChan invokes the iot.StartPTDetection API asynchronously
func (client *Client) StartPTDetectionWithChan(request *StartPTDetectionRequest) (<-chan *StartPTDetectionResponse, <-chan error) {
	responseChan := make(chan *StartPTDetectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartPTDetection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartPTDetectionWithCallback invokes the iot.StartPTDetection API asynchronously
func (client *Client) StartPTDetectionWithCallback(request *StartPTDetectionRequest, callback func(response *StartPTDetectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartPTDetectionResponse
		var err error
		defer close(result)
		response, err = client.StartPTDetection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartPTDetectionRequest is the request struct for api StartPTDetection
type StartPTDetectionRequest struct {
	*requests.RpcRequest
	PowerStationUid      string           `position:"Query" name:"PowerStationUid"`
	Data                 string           `position:"Query" name:"Data"`
	PowerPlantsNumber    requests.Integer `position:"Query" name:"PowerPlantsNumber"`
	IotInstanceId        string           `position:"Query" name:"IotInstanceId"`
	AlgorithmInstanceUid string           `position:"Query" name:"AlgorithmInstanceUid"`
	FileName             string           `position:"Query" name:"FileName"`
	ApiProduct           string           `position:"Body" name:"ApiProduct"`
	DataCollectionTime   requests.Integer `position:"Query" name:"DataCollectionTime"`
	ApiRevision          string           `position:"Body" name:"ApiRevision"`
	Sensitivity          requests.Integer `position:"Query" name:"Sensitivity"`
}

// StartPTDetectionResponse is the response struct for api StartPTDetection
type StartPTDetectionResponse struct {
	*responses.BaseResponse
	RequestId    string                 `json:"RequestId" xml:"RequestId"`
	Success      bool                   `json:"Success" xml:"Success"`
	Code         string                 `json:"Code" xml:"Code"`
	ErrorMessage string                 `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInStartPTDetection `json:"Data" xml:"Data"`
}

// CreateStartPTDetectionRequest creates a request to invoke StartPTDetection API
func CreateStartPTDetectionRequest() (request *StartPTDetectionRequest) {
	request = &StartPTDetectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "StartPTDetection", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartPTDetectionResponse creates a response to parse from StartPTDetection response
func CreateStartPTDetectionResponse() (response *StartPTDetectionResponse) {
	response = &StartPTDetectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
