package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRecordPlan invokes the linkvisual.DeleteRecordPlan API synchronously
func (client *Client) DeleteRecordPlan(request *DeleteRecordPlanRequest) (response *DeleteRecordPlanResponse, err error) {
	response = CreateDeleteRecordPlanResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRecordPlanWithChan invokes the linkvisual.DeleteRecordPlan API asynchronously
func (client *Client) DeleteRecordPlanWithChan(request *DeleteRecordPlanRequest) (<-chan *DeleteRecordPlanResponse, <-chan error) {
	responseChan := make(chan *DeleteRecordPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRecordPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRecordPlanWithCallback invokes the linkvisual.DeleteRecordPlan API asynchronously
func (client *Client) DeleteRecordPlanWithCallback(request *DeleteRecordPlanRequest, callback func(response *DeleteRecordPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRecordPlanResponse
		var err error
		defer close(result)
		response, err = client.DeleteRecordPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRecordPlanRequest is the request struct for api DeleteRecordPlan
type DeleteRecordPlanRequest struct {
	*requests.RpcRequest
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
	PlanId      string `position:"Query" name:"PlanId"`
}

// DeleteRecordPlanResponse is the response struct for api DeleteRecordPlan
type DeleteRecordPlanResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateDeleteRecordPlanRequest creates a request to invoke DeleteRecordPlan API
func CreateDeleteRecordPlanRequest() (request *DeleteRecordPlanRequest) {
	request = &DeleteRecordPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "DeleteRecordPlan", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteRecordPlanResponse creates a response to parse from DeleteRecordPlan response
func CreateDeleteRecordPlanResponse() (response *DeleteRecordPlanResponse) {
	response = &DeleteRecordPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
