package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectUserFaceByUrl invokes the linkvisual.DetectUserFaceByUrl API synchronously
func (client *Client) DetectUserFaceByUrl(request *DetectUserFaceByUrlRequest) (response *DetectUserFaceByUrlResponse, err error) {
	response = CreateDetectUserFaceByUrlResponse()
	err = client.DoAction(request, response)
	return
}

// DetectUserFaceByUrlWithChan invokes the linkvisual.DetectUserFaceByUrl API asynchronously
func (client *Client) DetectUserFaceByUrlWithChan(request *DetectUserFaceByUrlRequest) (<-chan *DetectUserFaceByUrlResponse, <-chan error) {
	responseChan := make(chan *DetectUserFaceByUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectUserFaceByUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectUserFaceByUrlWithCallback invokes the linkvisual.DetectUserFaceByUrl API asynchronously
func (client *Client) DetectUserFaceByUrlWithCallback(request *DetectUserFaceByUrlRequest, callback func(response *DetectUserFaceByUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectUserFaceByUrlResponse
		var err error
		defer close(result)
		response, err = client.DetectUserFaceByUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectUserFaceByUrlRequest is the request struct for api DetectUserFaceByUrl
type DetectUserFaceByUrlRequest struct {
	*requests.RpcRequest
	FacePicUrl  string `position:"Query" name:"FacePicUrl"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// DetectUserFaceByUrlResponse is the response struct for api DetectUserFaceByUrl
type DetectUserFaceByUrlResponse struct {
	*responses.BaseResponse
	Code         string                    `json:"Code" xml:"Code"`
	ErrorMessage string                    `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string                    `json:"RequestId" xml:"RequestId"`
	Success      bool                      `json:"Success" xml:"Success"`
	Data         DataInDetectUserFaceByUrl `json:"Data" xml:"Data"`
}

// CreateDetectUserFaceByUrlRequest creates a request to invoke DetectUserFaceByUrl API
func CreateDetectUserFaceByUrlRequest() (request *DetectUserFaceByUrlRequest) {
	request = &DetectUserFaceByUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "DetectUserFaceByUrl", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectUserFaceByUrlResponse creates a response to parse from DetectUserFaceByUrl response
func CreateDetectUserFaceByUrlResponse() (response *DetectUserFaceByUrlResponse) {
	response = &DetectUserFaceByUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
