package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableGbSubDevice invokes the linkvisual.EnableGbSubDevice API synchronously
func (client *Client) EnableGbSubDevice(request *EnableGbSubDeviceRequest) (response *EnableGbSubDeviceResponse, err error) {
	response = CreateEnableGbSubDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// EnableGbSubDeviceWithChan invokes the linkvisual.EnableGbSubDevice API asynchronously
func (client *Client) EnableGbSubDeviceWithChan(request *EnableGbSubDeviceRequest) (<-chan *EnableGbSubDeviceResponse, <-chan error) {
	responseChan := make(chan *EnableGbSubDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableGbSubDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableGbSubDeviceWithCallback invokes the linkvisual.EnableGbSubDevice API asynchronously
func (client *Client) EnableGbSubDeviceWithCallback(request *EnableGbSubDeviceRequest, callback func(response *EnableGbSubDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableGbSubDeviceResponse
		var err error
		defer close(result)
		response, err = client.EnableGbSubDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableGbSubDeviceRequest is the request struct for api EnableGbSubDevice
type EnableGbSubDeviceRequest struct {
	*requests.RpcRequest
	IotId         string `position:"Query" name:"IotId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	SubDeviceId   string `position:"Query" name:"SubDeviceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// EnableGbSubDeviceResponse is the response struct for api EnableGbSubDevice
type EnableGbSubDeviceResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateEnableGbSubDeviceRequest creates a request to invoke EnableGbSubDevice API
func CreateEnableGbSubDeviceRequest() (request *EnableGbSubDeviceRequest) {
	request = &EnableGbSubDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "EnableGbSubDevice", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableGbSubDeviceResponse creates a response to parse from EnableGbSubDevice response
func CreateEnableGbSubDeviceResponse() (response *EnableGbSubDeviceResponse) {
	response = &EnableGbSubDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
