package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCarProcessEvents invokes the linkvisual.QueryCarProcessEvents API synchronously
func (client *Client) QueryCarProcessEvents(request *QueryCarProcessEventsRequest) (response *QueryCarProcessEventsResponse, err error) {
	response = CreateQueryCarProcessEventsResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCarProcessEventsWithChan invokes the linkvisual.QueryCarProcessEvents API asynchronously
func (client *Client) QueryCarProcessEventsWithChan(request *QueryCarProcessEventsRequest) (<-chan *QueryCarProcessEventsResponse, <-chan error) {
	responseChan := make(chan *QueryCarProcessEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCarProcessEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCarProcessEventsWithCallback invokes the linkvisual.QueryCarProcessEvents API asynchronously
func (client *Client) QueryCarProcessEventsWithCallback(request *QueryCarProcessEventsRequest, callback func(response *QueryCarProcessEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCarProcessEventsResponse
		var err error
		defer close(result)
		response, err = client.QueryCarProcessEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCarProcessEventsRequest is the request struct for api QueryCarProcessEvents
type QueryCarProcessEventsRequest struct {
	*requests.RpcRequest
	ActionType    requests.Integer `position:"Query" name:"ActionType"`
	SubProductKey string           `position:"Query" name:"SubProductKey"`
	PlateNo       string           `position:"Query" name:"PlateNo"`
	IotId         string           `position:"Query" name:"IotId"`
	SubDeviceName string           `position:"Query" name:"SubDeviceName"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	EndTime       requests.Integer `position:"Query" name:"EndTime"`
	BeginTime     requests.Integer `position:"Query" name:"BeginTime"`
	CurrentPage   requests.Integer `position:"Query" name:"CurrentPage"`
	AreaIndex     requests.Integer `position:"Query" name:"AreaIndex"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	SubIotId      string           `position:"Query" name:"SubIotId"`
}

// QueryCarProcessEventsResponse is the response struct for api QueryCarProcessEvents
type QueryCarProcessEventsResponse struct {
	*responses.BaseResponse
	Code         string                      `json:"Code" xml:"Code"`
	ErrorMessage string                      `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string                      `json:"RequestId" xml:"RequestId"`
	Success      bool                        `json:"Success" xml:"Success"`
	Data         DataInQueryCarProcessEvents `json:"Data" xml:"Data"`
}

// CreateQueryCarProcessEventsRequest creates a request to invoke QueryCarProcessEvents API
func CreateQueryCarProcessEventsRequest() (request *QueryCarProcessEventsRequest) {
	request = &QueryCarProcessEventsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryCarProcessEvents", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryCarProcessEventsResponse creates a response to parse from QueryCarProcessEvents response
func CreateQueryCarProcessEventsResponse() (response *QueryCarProcessEventsResponse) {
	response = &QueryCarProcessEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
