package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryFaceAllUserIdsByGroupId invokes the linkvisual.QueryFaceAllUserIdsByGroupId API synchronously
func (client *Client) QueryFaceAllUserIdsByGroupId(request *QueryFaceAllUserIdsByGroupIdRequest) (response *QueryFaceAllUserIdsByGroupIdResponse, err error) {
	response = CreateQueryFaceAllUserIdsByGroupIdResponse()
	err = client.DoAction(request, response)
	return
}

// QueryFaceAllUserIdsByGroupIdWithChan invokes the linkvisual.QueryFaceAllUserIdsByGroupId API asynchronously
func (client *Client) QueryFaceAllUserIdsByGroupIdWithChan(request *QueryFaceAllUserIdsByGroupIdRequest) (<-chan *QueryFaceAllUserIdsByGroupIdResponse, <-chan error) {
	responseChan := make(chan *QueryFaceAllUserIdsByGroupIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryFaceAllUserIdsByGroupId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryFaceAllUserIdsByGroupIdWithCallback invokes the linkvisual.QueryFaceAllUserIdsByGroupId API asynchronously
func (client *Client) QueryFaceAllUserIdsByGroupIdWithCallback(request *QueryFaceAllUserIdsByGroupIdRequest, callback func(response *QueryFaceAllUserIdsByGroupIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryFaceAllUserIdsByGroupIdResponse
		var err error
		defer close(result)
		response, err = client.QueryFaceAllUserIdsByGroupId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryFaceAllUserIdsByGroupIdRequest is the request struct for api QueryFaceAllUserIdsByGroupId
type QueryFaceAllUserIdsByGroupIdRequest struct {
	*requests.RpcRequest
	IsolationId string           `position:"Query" name:"IsolationId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	UserGroupId string           `position:"Query" name:"UserGroupId"`
	PageNo      requests.Integer `position:"Query" name:"PageNo"`
	ApiProduct  string           `position:"Body" name:"ApiProduct"`
	ApiRevision string           `position:"Body" name:"ApiRevision"`
}

// QueryFaceAllUserIdsByGroupIdResponse is the response struct for api QueryFaceAllUserIdsByGroupId
type QueryFaceAllUserIdsByGroupIdResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryFaceAllUserIdsByGroupIdRequest creates a request to invoke QueryFaceAllUserIdsByGroupId API
func CreateQueryFaceAllUserIdsByGroupIdRequest() (request *QueryFaceAllUserIdsByGroupIdRequest) {
	request = &QueryFaceAllUserIdsByGroupIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryFaceAllUserIdsByGroupId", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryFaceAllUserIdsByGroupIdResponse creates a response to parse from QueryFaceAllUserIdsByGroupId response
func CreateQueryFaceAllUserIdsByGroupIdResponse() (response *QueryFaceAllUserIdsByGroupIdResponse) {
	response = &QueryFaceAllUserIdsByGroupIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
