package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopLiveStreaming invokes the linkvisual.StopLiveStreaming API synchronously
func (client *Client) StopLiveStreaming(request *StopLiveStreamingRequest) (response *StopLiveStreamingResponse, err error) {
	response = CreateStopLiveStreamingResponse()
	err = client.DoAction(request, response)
	return
}

// StopLiveStreamingWithChan invokes the linkvisual.StopLiveStreaming API asynchronously
func (client *Client) StopLiveStreamingWithChan(request *StopLiveStreamingRequest) (<-chan *StopLiveStreamingResponse, <-chan error) {
	responseChan := make(chan *StopLiveStreamingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopLiveStreaming(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopLiveStreamingWithCallback invokes the linkvisual.StopLiveStreaming API asynchronously
func (client *Client) StopLiveStreamingWithCallback(request *StopLiveStreamingRequest, callback func(response *StopLiveStreamingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopLiveStreamingResponse
		var err error
		defer close(result)
		response, err = client.StopLiveStreaming(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopLiveStreamingRequest is the request struct for api StopLiveStreaming
type StopLiveStreamingRequest struct {
	*requests.RpcRequest
	IotId         string           `position:"Query" name:"IotId"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	StreamType    requests.Integer `position:"Query" name:"StreamType"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	DeviceName    string           `position:"Query" name:"DeviceName"`
}

// StopLiveStreamingResponse is the response struct for api StopLiveStreaming
type StopLiveStreamingResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateStopLiveStreamingRequest creates a request to invoke StopLiveStreaming API
func CreateStopLiveStreamingRequest() (request *StopLiveStreamingRequest) {
	request = &StopLiveStreamingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "StopLiveStreaming", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopLiveStreamingResponse creates a response to parse from StopLiveStreaming response
func CreateStopLiveStreamingResponse() (response *StopLiveStreamingResponse) {
	response = &StopLiveStreamingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
