package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateFaceUser invokes the linkvisual.UpdateFaceUser API synchronously
func (client *Client) UpdateFaceUser(request *UpdateFaceUserRequest) (response *UpdateFaceUserResponse, err error) {
	response = CreateUpdateFaceUserResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateFaceUserWithChan invokes the linkvisual.UpdateFaceUser API asynchronously
func (client *Client) UpdateFaceUserWithChan(request *UpdateFaceUserRequest) (<-chan *UpdateFaceUserResponse, <-chan error) {
	responseChan := make(chan *UpdateFaceUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateFaceUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateFaceUserWithCallback invokes the linkvisual.UpdateFaceUser API asynchronously
func (client *Client) UpdateFaceUserWithCallback(request *UpdateFaceUserRequest, callback func(response *UpdateFaceUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateFaceUserResponse
		var err error
		defer close(result)
		response, err = client.UpdateFaceUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateFaceUserRequest is the request struct for api UpdateFaceUser
type UpdateFaceUserRequest struct {
	*requests.RpcRequest
	IsolationId  string `position:"Query" name:"IsolationId"`
	UserId       string `position:"Query" name:"UserId"`
	CustomUserId string `position:"Query" name:"CustomUserId"`
	Params       string `position:"Query" name:"Params"`
	FacePicUrl   string `position:"Query" name:"FacePicUrl"`
	ApiProduct   string `position:"Body" name:"ApiProduct"`
	Name         string `position:"Query" name:"Name"`
	ApiRevision  string `position:"Body" name:"ApiRevision"`
}

// UpdateFaceUserResponse is the response struct for api UpdateFaceUser
type UpdateFaceUserResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateUpdateFaceUserRequest creates a request to invoke UpdateFaceUser API
func CreateUpdateFaceUserRequest() (request *UpdateFaceUserRequest) {
	request = &UpdateFaceUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "UpdateFaceUser", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateFaceUserResponse creates a response to parse from UpdateFaceUser response
func CreateUpdateFaceUserResponse() (response *UpdateFaceUserResponse) {
	response = &UpdateFaceUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
