package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveUserBillPrediction invokes the live.DescribeLiveUserBillPrediction API synchronously
func (client *Client) DescribeLiveUserBillPrediction(request *DescribeLiveUserBillPredictionRequest) (response *DescribeLiveUserBillPredictionResponse, err error) {
	response = CreateDescribeLiveUserBillPredictionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveUserBillPredictionWithChan invokes the live.DescribeLiveUserBillPrediction API asynchronously
func (client *Client) DescribeLiveUserBillPredictionWithChan(request *DescribeLiveUserBillPredictionRequest) (<-chan *DescribeLiveUserBillPredictionResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveUserBillPredictionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveUserBillPrediction(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveUserBillPredictionWithCallback invokes the live.DescribeLiveUserBillPrediction API asynchronously
func (client *Client) DescribeLiveUserBillPredictionWithCallback(request *DescribeLiveUserBillPredictionRequest, callback func(response *DescribeLiveUserBillPredictionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveUserBillPredictionResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveUserBillPrediction(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveUserBillPredictionRequest is the request struct for api DescribeLiveUserBillPrediction
type DescribeLiveUserBillPredictionRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveUserBillPredictionResponse is the response struct for api DescribeLiveUserBillPrediction
type DescribeLiveUserBillPredictionResponse struct {
	*responses.BaseResponse
	EndTime            string             `json:"EndTime" xml:"EndTime"`
	StartTime          string             `json:"StartTime" xml:"StartTime"`
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	BillType           string             `json:"BillType" xml:"BillType"`
	BillPredictionData BillPredictionData `json:"BillPredictionData" xml:"BillPredictionData"`
}

// CreateDescribeLiveUserBillPredictionRequest creates a request to invoke DescribeLiveUserBillPrediction API
func CreateDescribeLiveUserBillPredictionRequest() (request *DescribeLiveUserBillPredictionRequest) {
	request = &DescribeLiveUserBillPredictionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveUserBillPrediction", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveUserBillPredictionResponse creates a response to parse from DescribeLiveUserBillPrediction response
func CreateDescribeLiveUserBillPredictionResponse() (response *DescribeLiveUserBillPredictionResponse) {
	response = &DescribeLiveUserBillPredictionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
