package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLiveMessageGroupMessages invokes the live.ListLiveMessageGroupMessages API synchronously
func (client *Client) ListLiveMessageGroupMessages(request *ListLiveMessageGroupMessagesRequest) (response *ListLiveMessageGroupMessagesResponse, err error) {
	response = CreateListLiveMessageGroupMessagesResponse()
	err = client.DoAction(request, response)
	return
}

// ListLiveMessageGroupMessagesWithChan invokes the live.ListLiveMessageGroupMessages API asynchronously
func (client *Client) ListLiveMessageGroupMessagesWithChan(request *ListLiveMessageGroupMessagesRequest) (<-chan *ListLiveMessageGroupMessagesResponse, <-chan error) {
	responseChan := make(chan *ListLiveMessageGroupMessagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLiveMessageGroupMessages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLiveMessageGroupMessagesWithCallback invokes the live.ListLiveMessageGroupMessages API asynchronously
func (client *Client) ListLiveMessageGroupMessagesWithCallback(request *ListLiveMessageGroupMessagesRequest, callback func(response *ListLiveMessageGroupMessagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLiveMessageGroupMessagesResponse
		var err error
		defer close(result)
		response, err = client.ListLiveMessageGroupMessages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLiveMessageGroupMessagesRequest is the request struct for api ListLiveMessageGroupMessages
type ListLiveMessageGroupMessagesRequest struct {
	*requests.RpcRequest
	SortType      requests.Integer `position:"Query" name:"SortType"`
	NextPageToken requests.Integer `position:"Query" name:"NextPageToken"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	MsgType       requests.Integer `position:"Query" name:"MsgType"`
	GroupId       string           `position:"Query" name:"GroupId"`
	EndTime       requests.Integer `position:"Query" name:"EndTime"`
	BeginTime     requests.Integer `position:"Query" name:"BeginTime"`
	DataCenter    string           `position:"Query" name:"DataCenter"`
	AppId         string           `position:"Query" name:"AppId"`
}

// ListLiveMessageGroupMessagesResponse is the response struct for api ListLiveMessageGroupMessages
type ListLiveMessageGroupMessagesResponse struct {
	*responses.BaseResponse
	RequestId     string     `json:"RequestId" xml:"RequestId"`
	GroupId       string     `json:"GroupId" xml:"GroupId"`
	NextPageToken int64      `json:"NextPageToken" xml:"NextPageToken"`
	Hasmore       bool       `json:"Hasmore" xml:"Hasmore"`
	MessageList   []Messages `json:"MessageList" xml:"MessageList"`
}

// CreateListLiveMessageGroupMessagesRequest creates a request to invoke ListLiveMessageGroupMessages API
func CreateListLiveMessageGroupMessagesRequest() (request *ListLiveMessageGroupMessagesRequest) {
	request = &ListLiveMessageGroupMessagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ListLiveMessageGroupMessages", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListLiveMessageGroupMessagesResponse creates a response to parse from ListLiveMessageGroupMessages response
func CreateListLiveMessageGroupMessagesResponse() (response *ListLiveMessageGroupMessagesResponse) {
	response = &ListLiveMessageGroupMessagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
