package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMessageApp invokes the live.ListMessageApp API synchronously
func (client *Client) ListMessageApp(request *ListMessageAppRequest) (response *ListMessageAppResponse, err error) {
	response = CreateListMessageAppResponse()
	err = client.DoAction(request, response)
	return
}

// ListMessageAppWithChan invokes the live.ListMessageApp API asynchronously
func (client *Client) ListMessageAppWithChan(request *ListMessageAppRequest) (<-chan *ListMessageAppResponse, <-chan error) {
	responseChan := make(chan *ListMessageAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMessageApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMessageAppWithCallback invokes the live.ListMessageApp API asynchronously
func (client *Client) ListMessageAppWithCallback(request *ListMessageAppRequest, callback func(response *ListMessageAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMessageAppResponse
		var err error
		defer close(result)
		response, err = client.ListMessageApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMessageAppRequest is the request struct for api ListMessageApp
type ListMessageAppRequest struct {
	*requests.RpcRequest
	SortType requests.Integer `position:"Body" name:"SortType"`
	PageNum  requests.Integer `position:"Body" name:"PageNum"`
	PageSize requests.Integer `position:"Body" name:"PageSize"`
}

// ListMessageAppResponse is the response struct for api ListMessageApp
type ListMessageAppResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateListMessageAppRequest creates a request to invoke ListMessageApp API
func CreateListMessageAppRequest() (request *ListMessageAppRequest) {
	request = &ListMessageAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ListMessageApp", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListMessageAppResponse creates a response to parse from ListMessageApp response
func CreateListMessageAppResponse() (response *ListMessageAppResponse) {
	response = &ListMessageAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
