package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMessageGroupUserById invokes the live.ListMessageGroupUserById API synchronously
func (client *Client) ListMessageGroupUserById(request *ListMessageGroupUserByIdRequest) (response *ListMessageGroupUserByIdResponse, err error) {
	response = CreateListMessageGroupUserByIdResponse()
	err = client.DoAction(request, response)
	return
}

// ListMessageGroupUserByIdWithChan invokes the live.ListMessageGroupUserById API asynchronously
func (client *Client) ListMessageGroupUserByIdWithChan(request *ListMessageGroupUserByIdRequest) (<-chan *ListMessageGroupUserByIdResponse, <-chan error) {
	responseChan := make(chan *ListMessageGroupUserByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMessageGroupUserById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMessageGroupUserByIdWithCallback invokes the live.ListMessageGroupUserById API asynchronously
func (client *Client) ListMessageGroupUserByIdWithCallback(request *ListMessageGroupUserByIdRequest, callback func(response *ListMessageGroupUserByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMessageGroupUserByIdResponse
		var err error
		defer close(result)
		response, err = client.ListMessageGroupUserById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMessageGroupUserByIdRequest is the request struct for api ListMessageGroupUserById
type ListMessageGroupUserByIdRequest struct {
	*requests.RpcRequest
	UserIdList *[]string `position:"Body" name:"UserIdList"  type:"Repeated"`
	GroupId    string    `position:"Body" name:"GroupId"`
	AppId      string    `position:"Body" name:"AppId"`
}

// ListMessageGroupUserByIdResponse is the response struct for api ListMessageGroupUserById
type ListMessageGroupUserByIdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateListMessageGroupUserByIdRequest creates a request to invoke ListMessageGroupUserById API
func CreateListMessageGroupUserByIdRequest() (request *ListMessageGroupUserByIdRequest) {
	request = &ListMessageGroupUserByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ListMessageGroupUserById", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListMessageGroupUserByIdResponse creates a response to parse from ListMessageGroupUserById response
func CreateListMessageGroupUserByIdResponse() (response *ListMessageGroupUserByIdResponse) {
	response = &ListMessageGroupUserByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
