package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMember invokes the ltl.ListMember API synchronously
func (client *Client) ListMember(request *ListMemberRequest) (response *ListMemberResponse, err error) {
	response = CreateListMemberResponse()
	err = client.DoAction(request, response)
	return
}

// ListMemberWithChan invokes the ltl.ListMember API asynchronously
func (client *Client) ListMemberWithChan(request *ListMemberRequest) (<-chan *ListMemberResponse, <-chan error) {
	responseChan := make(chan *ListMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMemberWithCallback invokes the ltl.ListMember API asynchronously
func (client *Client) ListMemberWithCallback(request *ListMemberRequest, callback func(response *ListMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMemberResponse
		var err error
		defer close(result)
		response, err = client.ListMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMemberRequest is the request struct for api ListMember
type ListMemberRequest struct {
	*requests.RpcRequest
	Size       requests.Integer `position:"Query" name:"Size"`
	MemberUid  string           `position:"Query" name:"MemberUid"`
	Num        requests.Integer `position:"Query" name:"Num"`
	ApiVersion string           `position:"Query" name:"ApiVersion"`
	BizChainId string           `position:"Query" name:"BizChainId"`
}

// ListMemberResponse is the response struct for api ListMember
type ListMemberResponse struct {
	*responses.BaseResponse
	Code      int              `json:"Code" xml:"Code"`
	Message   string           `json:"Message" xml:"Message"`
	RequestId string           `json:"RequestId" xml:"RequestId"`
	Success   bool             `json:"Success" xml:"Success"`
	Data      DataInListMember `json:"Data" xml:"Data"`
}

// CreateListMemberRequest creates a request to invoke ListMember API
func CreateListMemberRequest() (request *ListMemberRequest) {
	request = &ListMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "ListMember", "", "")
	request.Method = requests.POST
	return
}

// CreateListMemberResponse creates a response to parse from ListMember response
func CreateListMemberResponse() (response *ListMemberResponse) {
	response = &ListMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
