package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddBaaSFabricBizChain invokes the lto.AddBaaSFabricBizChain API synchronously
func (client *Client) AddBaaSFabricBizChain(request *AddBaaSFabricBizChainRequest) (response *AddBaaSFabricBizChainResponse, err error) {
	response = CreateAddBaaSFabricBizChainResponse()
	err = client.DoAction(request, response)
	return
}

// AddBaaSFabricBizChainWithChan invokes the lto.AddBaaSFabricBizChain API asynchronously
func (client *Client) AddBaaSFabricBizChainWithChan(request *AddBaaSFabricBizChainRequest) (<-chan *AddBaaSFabricBizChainResponse, <-chan error) {
	responseChan := make(chan *AddBaaSFabricBizChainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddBaaSFabricBizChain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddBaaSFabricBizChainWithCallback invokes the lto.AddBaaSFabricBizChain API asynchronously
func (client *Client) AddBaaSFabricBizChainWithCallback(request *AddBaaSFabricBizChainRequest, callback func(response *AddBaaSFabricBizChainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddBaaSFabricBizChainResponse
		var err error
		defer close(result)
		response, err = client.AddBaaSFabricBizChain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddBaaSFabricBizChainRequest is the request struct for api AddBaaSFabricBizChain
type AddBaaSFabricBizChainRequest struct {
	*requests.RpcRequest
	BaaSFabricConsortiumId   string `position:"Query" name:"BaaSFabricConsortiumId"`
	Remark                   string `position:"Query" name:"Remark"`
	Name                     string `position:"Query" name:"Name"`
	BaaSFabricChannelId      string `position:"Query" name:"BaaSFabricChannelId"`
	BaaSFabricOrganizationId string `position:"Query" name:"BaaSFabricOrganizationId"`
	ContractTemplateIdList   string `position:"Query" name:"ContractTemplateIdList"`
}

// AddBaaSFabricBizChainResponse is the response struct for api AddBaaSFabricBizChain
type AddBaaSFabricBizChainResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateAddBaaSFabricBizChainRequest creates a request to invoke AddBaaSFabricBizChain API
func CreateAddBaaSFabricBizChainRequest() (request *AddBaaSFabricBizChainRequest) {
	request = &AddBaaSFabricBizChainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "AddBaaSFabricBizChain", "", "")
	request.Method = requests.POST
	return
}

// CreateAddBaaSFabricBizChainResponse creates a response to parse from AddBaaSFabricBizChain response
func CreateAddBaaSFabricBizChainResponse() (response *AddBaaSFabricBizChainResponse) {
	response = &AddBaaSFabricBizChainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
