package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryBlockchainData invokes the lto.QueryBlockchainData API synchronously
func (client *Client) QueryBlockchainData(request *QueryBlockchainDataRequest) (response *QueryBlockchainDataResponse, err error) {
	response = CreateQueryBlockchainDataResponse()
	err = client.DoAction(request, response)
	return
}

// QueryBlockchainDataWithChan invokes the lto.QueryBlockchainData API asynchronously
func (client *Client) QueryBlockchainDataWithChan(request *QueryBlockchainDataRequest) (<-chan *QueryBlockchainDataResponse, <-chan error) {
	responseChan := make(chan *QueryBlockchainDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryBlockchainData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryBlockchainDataWithCallback invokes the lto.QueryBlockchainData API asynchronously
func (client *Client) QueryBlockchainDataWithCallback(request *QueryBlockchainDataRequest, callback func(response *QueryBlockchainDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryBlockchainDataResponse
		var err error
		defer close(result)
		response, err = client.QueryBlockchainData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryBlockchainDataRequest is the request struct for api QueryBlockchainData
type QueryBlockchainDataRequest struct {
	*requests.RpcRequest
	ContractName  string `position:"Query" name:"ContractName"`
	BizChainId    string `position:"Query" name:"BizChainId"`
	TransactionId string `position:"Query" name:"TransactionId"`
	InvokeType    string `position:"Query" name:"InvokeType"`
	IotDataDID    string `position:"Query" name:"IotDataDID"`
}

// QueryBlockchainDataResponse is the response struct for api QueryBlockchainData
type QueryBlockchainDataResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryBlockchainDataRequest creates a request to invoke QueryBlockchainData API
func CreateQueryBlockchainDataRequest() (request *QueryBlockchainDataRequest) {
	request = &QueryBlockchainDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "QueryBlockchainData", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryBlockchainDataResponse creates a response to parse from QueryBlockchainData response
func CreateQueryBlockchainDataResponse() (response *QueryBlockchainDataResponse) {
	response = &QueryBlockchainDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
