package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMcdpZone invokes the mpaas.DeleteMcdpZone API synchronously
func (client *Client) DeleteMcdpZone(request *DeleteMcdpZoneRequest) (response *DeleteMcdpZoneResponse, err error) {
	response = CreateDeleteMcdpZoneResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMcdpZoneWithChan invokes the mpaas.DeleteMcdpZone API asynchronously
func (client *Client) DeleteMcdpZoneWithChan(request *DeleteMcdpZoneRequest) (<-chan *DeleteMcdpZoneResponse, <-chan error) {
	responseChan := make(chan *DeleteMcdpZoneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMcdpZone(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMcdpZoneWithCallback invokes the mpaas.DeleteMcdpZone API asynchronously
func (client *Client) DeleteMcdpZoneWithCallback(request *DeleteMcdpZoneRequest, callback func(response *DeleteMcdpZoneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMcdpZoneResponse
		var err error
		defer close(result)
		response, err = client.DeleteMcdpZone(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMcdpZoneRequest is the request struct for api DeleteMcdpZone
type DeleteMcdpZoneRequest struct {
	*requests.RpcRequest
	MpaasMappcenterMcdpZoneDeleteJsonStr string `position:"Body" name:"MpaasMappcenterMcdpZoneDeleteJsonStr"`
	TenantId                             string `position:"Body" name:"TenantId"`
	AppId                                string `position:"Body" name:"AppId"`
	WorkspaceId                          string `position:"Body" name:"WorkspaceId"`
}

// DeleteMcdpZoneResponse is the response struct for api DeleteMcdpZone
type DeleteMcdpZoneResponse struct {
	*responses.BaseResponse
	ResultMessage string                        `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                        `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                        `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInDeleteMcdpZone `json:"ResultContent" xml:"ResultContent"`
}

// CreateDeleteMcdpZoneRequest creates a request to invoke DeleteMcdpZone API
func CreateDeleteMcdpZoneRequest() (request *DeleteMcdpZoneRequest) {
	request = &DeleteMcdpZoneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "DeleteMcdpZone", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteMcdpZoneResponse creates a response to parse from DeleteMcdpZone response
func CreateDeleteMcdpZoneResponse() (response *DeleteMcdpZoneResponse) {
	response = &DeleteMcdpZoneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
