package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMcubeMiniTask invokes the mpaas.QueryMcubeMiniTask API synchronously
func (client *Client) QueryMcubeMiniTask(request *QueryMcubeMiniTaskRequest) (response *QueryMcubeMiniTaskResponse, err error) {
	response = CreateQueryMcubeMiniTaskResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMcubeMiniTaskWithChan invokes the mpaas.QueryMcubeMiniTask API asynchronously
func (client *Client) QueryMcubeMiniTaskWithChan(request *QueryMcubeMiniTaskRequest) (<-chan *QueryMcubeMiniTaskResponse, <-chan error) {
	responseChan := make(chan *QueryMcubeMiniTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMcubeMiniTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMcubeMiniTaskWithCallback invokes the mpaas.QueryMcubeMiniTask API asynchronously
func (client *Client) QueryMcubeMiniTaskWithCallback(request *QueryMcubeMiniTaskRequest, callback func(response *QueryMcubeMiniTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMcubeMiniTaskResponse
		var err error
		defer close(result)
		response, err = client.QueryMcubeMiniTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMcubeMiniTaskRequest is the request struct for api QueryMcubeMiniTask
type QueryMcubeMiniTaskRequest struct {
	*requests.RpcRequest
	TenantId    string           `position:"Body" name:"TenantId"`
	TaskId      requests.Integer `position:"Body" name:"TaskId"`
	AppId       string           `position:"Body" name:"AppId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// QueryMcubeMiniTaskResponse is the response struct for api QueryMcubeMiniTask
type QueryMcubeMiniTaskResponse struct {
	*responses.BaseResponse
	ResultMessage       string              `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode          string              `json:"ResultCode" xml:"ResultCode"`
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	QueryMiniTaskResult QueryMiniTaskResult `json:"QueryMiniTaskResult" xml:"QueryMiniTaskResult"`
}

// CreateQueryMcubeMiniTaskRequest creates a request to invoke QueryMcubeMiniTask API
func CreateQueryMcubeMiniTaskRequest() (request *QueryMcubeMiniTaskRequest) {
	request = &QueryMcubeMiniTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "QueryMcubeMiniTask", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryMcubeMiniTaskResponse creates a response to parse from QueryMcubeMiniTask response
func CreateQueryMcubeMiniTaskResponse() (response *QueryMcubeMiniTaskResponse) {
	response = &QueryMcubeMiniTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
