package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGatewayCircuitBreakerRule invokes the mse.CreateGatewayCircuitBreakerRule API synchronously
func (client *Client) CreateGatewayCircuitBreakerRule(request *CreateGatewayCircuitBreakerRuleRequest) (response *CreateGatewayCircuitBreakerRuleResponse, err error) {
	response = CreateCreateGatewayCircuitBreakerRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGatewayCircuitBreakerRuleWithChan invokes the mse.CreateGatewayCircuitBreakerRule API asynchronously
func (client *Client) CreateGatewayCircuitBreakerRuleWithChan(request *CreateGatewayCircuitBreakerRuleRequest) (<-chan *CreateGatewayCircuitBreakerRuleResponse, <-chan error) {
	responseChan := make(chan *CreateGatewayCircuitBreakerRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGatewayCircuitBreakerRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGatewayCircuitBreakerRuleWithCallback invokes the mse.CreateGatewayCircuitBreakerRule API asynchronously
func (client *Client) CreateGatewayCircuitBreakerRuleWithCallback(request *CreateGatewayCircuitBreakerRuleRequest, callback func(response *CreateGatewayCircuitBreakerRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGatewayCircuitBreakerRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateGatewayCircuitBreakerRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGatewayCircuitBreakerRuleRequest is the request struct for api CreateGatewayCircuitBreakerRule
type CreateGatewayCircuitBreakerRuleRequest struct {
	*requests.RpcRequest
	MseSessionId        string           `position:"Query" name:"MseSessionId"`
	MaxAllowedMs        requests.Integer `position:"Query" name:"MaxAllowedMs"`
	BehaviorType        requests.Integer `position:"Query" name:"BehaviorType"`
	Enable              requests.Integer `position:"Query" name:"Enable"`
	MinRequestAmount    requests.Integer `position:"Query" name:"MinRequestAmount"`
	GatewayId           requests.Integer `position:"Query" name:"GatewayId"`
	ResponseStatusCode  requests.Integer `position:"Query" name:"ResponseStatusCode"`
	RouteId             requests.Integer `position:"Query" name:"RouteId"`
	TriggerRatio        requests.Integer `position:"Query" name:"TriggerRatio"`
	GatewayUniqueId     string           `position:"Query" name:"GatewayUniqueId"`
	BodyEncoding        requests.Integer `position:"Query" name:"BodyEncoding"`
	ResponseRedirectUrl string           `position:"Query" name:"ResponseRedirectUrl"`
	RouteName           string           `position:"Query" name:"RouteName"`
	StatDurationSec     requests.Integer `position:"Query" name:"StatDurationSec"`
	RecoveryTimeoutSec  requests.Integer `position:"Query" name:"RecoveryTimeoutSec"`
	AcceptLanguage      string           `position:"Query" name:"AcceptLanguage"`
	ResponseContentBody string           `position:"Query" name:"ResponseContentBody"`
	Strategy            requests.Integer `position:"Query" name:"Strategy"`
}

// CreateGatewayCircuitBreakerRuleResponse is the response struct for api CreateGatewayCircuitBreakerRule
type CreateGatewayCircuitBreakerRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      int64  `json:"Data" xml:"Data"`
}

// CreateCreateGatewayCircuitBreakerRuleRequest creates a request to invoke CreateGatewayCircuitBreakerRule API
func CreateCreateGatewayCircuitBreakerRuleRequest() (request *CreateGatewayCircuitBreakerRuleRequest) {
	request = &CreateGatewayCircuitBreakerRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "CreateGatewayCircuitBreakerRule", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateGatewayCircuitBreakerRuleResponse creates a response to parse from CreateGatewayCircuitBreakerRule response
func CreateCreateGatewayCircuitBreakerRuleResponse() (response *CreateGatewayCircuitBreakerRuleResponse) {
	response = &CreateGatewayCircuitBreakerRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
