package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGatewayIsolationRule invokes the mse.ListGatewayIsolationRule API synchronously
func (client *Client) ListGatewayIsolationRule(request *ListGatewayIsolationRuleRequest) (response *ListGatewayIsolationRuleResponse, err error) {
	response = CreateListGatewayIsolationRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ListGatewayIsolationRuleWithChan invokes the mse.ListGatewayIsolationRule API asynchronously
func (client *Client) ListGatewayIsolationRuleWithChan(request *ListGatewayIsolationRuleRequest) (<-chan *ListGatewayIsolationRuleResponse, <-chan error) {
	responseChan := make(chan *ListGatewayIsolationRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGatewayIsolationRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGatewayIsolationRuleWithCallback invokes the mse.ListGatewayIsolationRule API asynchronously
func (client *Client) ListGatewayIsolationRuleWithCallback(request *ListGatewayIsolationRuleRequest, callback func(response *ListGatewayIsolationRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGatewayIsolationRuleResponse
		var err error
		defer close(result)
		response, err = client.ListGatewayIsolationRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGatewayIsolationRuleRequest is the request struct for api ListGatewayIsolationRule
type ListGatewayIsolationRuleRequest struct {
	*requests.RpcRequest
	MseSessionId   string `position:"Query" name:"MseSessionId"`
	FilterParams   string `position:"Query" name:"FilterParams"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
}

// ListGatewayIsolationRuleResponse is the response struct for api ListGatewayIsolationRule
type ListGatewayIsolationRuleResponse struct {
	*responses.BaseResponse
	RequestId string                         `json:"RequestId" xml:"RequestId"`
	Data      DataInListGatewayIsolationRule `json:"Data" xml:"Data"`
}

// CreateListGatewayIsolationRuleRequest creates a request to invoke ListGatewayIsolationRule API
func CreateListGatewayIsolationRuleRequest() (request *ListGatewayIsolationRuleRequest) {
	request = &ListGatewayIsolationRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListGatewayIsolationRule", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListGatewayIsolationRuleResponse creates a response to parse from ListGatewayIsolationRule response
func CreateListGatewayIsolationRuleResponse() (response *ListGatewayIsolationRuleResponse) {
	response = &ListGatewayIsolationRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
