package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateCircuitBreakerRule invokes the mse.UpdateCircuitBreakerRule API synchronously
func (client *Client) UpdateCircuitBreakerRule(request *UpdateCircuitBreakerRuleRequest) (response *UpdateCircuitBreakerRuleResponse, err error) {
	response = CreateUpdateCircuitBreakerRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateCircuitBreakerRuleWithChan invokes the mse.UpdateCircuitBreakerRule API asynchronously
func (client *Client) UpdateCircuitBreakerRuleWithChan(request *UpdateCircuitBreakerRuleRequest) (<-chan *UpdateCircuitBreakerRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateCircuitBreakerRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateCircuitBreakerRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateCircuitBreakerRuleWithCallback invokes the mse.UpdateCircuitBreakerRule API asynchronously
func (client *Client) UpdateCircuitBreakerRuleWithCallback(request *UpdateCircuitBreakerRuleRequest, callback func(response *UpdateCircuitBreakerRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateCircuitBreakerRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateCircuitBreakerRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateCircuitBreakerRuleRequest is the request struct for api UpdateCircuitBreakerRule
type UpdateCircuitBreakerRuleRequest struct {
	*requests.RpcRequest
	MseSessionId              string           `position:"Query" name:"MseSessionId"`
	Threshold                 requests.Float   `position:"Query" name:"Threshold"`
	RetryTimeoutMs            requests.Integer `position:"Query" name:"RetryTimeoutMs"`
	AppName                   string           `position:"Query" name:"AppName"`
	Enable                    requests.Boolean `position:"Query" name:"Enable"`
	MinRequestAmount          requests.Integer `position:"Query" name:"MinRequestAmount"`
	MaxAllowedRtMs            requests.Integer `position:"Query" name:"MaxAllowedRtMs"`
	RuleId                    requests.Integer `position:"Query" name:"RuleId"`
	HalfOpenBaseAmountPerStep requests.Integer `position:"Query" name:"HalfOpenBaseAmountPerStep"`
	StatIntervalMs            requests.Integer `position:"Query" name:"StatIntervalMs"`
	AppId                     string           `position:"Query" name:"AppId"`
	Namespace                 string           `position:"Query" name:"Namespace"`
	HalfOpenRecoveryStepNum   requests.Integer `position:"Query" name:"HalfOpenRecoveryStepNum"`
	AcceptLanguage            string           `position:"Query" name:"AcceptLanguage"`
	Strategy                  requests.Integer `position:"Query" name:"Strategy"`
}

// UpdateCircuitBreakerRuleResponse is the response struct for api UpdateCircuitBreakerRule
type UpdateCircuitBreakerRuleResponse struct {
	*responses.BaseResponse
	Message   string                         `json:"Message" xml:"Message"`
	RequestId string                         `json:"RequestId" xml:"RequestId"`
	Code      string                         `json:"Code" xml:"Code"`
	Success   bool                           `json:"Success" xml:"Success"`
	Data      DataInUpdateCircuitBreakerRule `json:"Data" xml:"Data"`
}

// CreateUpdateCircuitBreakerRuleRequest creates a request to invoke UpdateCircuitBreakerRule API
func CreateUpdateCircuitBreakerRuleRequest() (request *UpdateCircuitBreakerRuleRequest) {
	request = &UpdateCircuitBreakerRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateCircuitBreakerRule", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateCircuitBreakerRuleResponse creates a response to parse from UpdateCircuitBreakerRule response
func CreateUpdateCircuitBreakerRuleResponse() (response *UpdateCircuitBreakerRuleResponse) {
	response = &UpdateCircuitBreakerRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
