package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCustomGroups invokes the mts.ListCustomGroups API synchronously
func (client *Client) ListCustomGroups(request *ListCustomGroupsRequest) (response *ListCustomGroupsResponse, err error) {
	response = CreateListCustomGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListCustomGroupsWithChan invokes the mts.ListCustomGroups API asynchronously
func (client *Client) ListCustomGroupsWithChan(request *ListCustomGroupsRequest) (<-chan *ListCustomGroupsResponse, <-chan error) {
	responseChan := make(chan *ListCustomGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCustomGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCustomGroupsWithCallback invokes the mts.ListCustomGroups API asynchronously
func (client *Client) ListCustomGroupsWithCallback(request *ListCustomGroupsRequest, callback func(response *ListCustomGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCustomGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListCustomGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCustomGroupsRequest is the request struct for api ListCustomGroups
type ListCustomGroupsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	Algorithm            string           `position:"Query" name:"Algorithm"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ListCustomGroupsResponse is the response struct for api ListCustomGroups
type ListCustomGroupsResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	PageNumber   int          `json:"PageNumber" xml:"PageNumber"`
	PageSize     int          `json:"PageSize" xml:"PageSize"`
	TotalCount   int64        `json:"TotalCount" xml:"TotalCount"`
	CustomGroups CustomGroups `json:"CustomGroups" xml:"CustomGroups"`
}

// CreateListCustomGroupsRequest creates a request to invoke ListCustomGroups API
func CreateListCustomGroupsRequest() (request *ListCustomGroupsRequest) {
	request = &ListCustomGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "ListCustomGroups", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListCustomGroupsResponse creates a response to parse from ListCustomGroups response
func CreateListCustomGroupsResponse() (response *ListCustomGroupsResponse) {
	response = &ListCustomGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
