package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCopyrightExtractJob invokes the mts.QueryCopyrightExtractJob API synchronously
func (client *Client) QueryCopyrightExtractJob(request *QueryCopyrightExtractJobRequest) (response *QueryCopyrightExtractJobResponse, err error) {
	response = CreateQueryCopyrightExtractJobResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCopyrightExtractJobWithChan invokes the mts.QueryCopyrightExtractJob API asynchronously
func (client *Client) QueryCopyrightExtractJobWithChan(request *QueryCopyrightExtractJobRequest) (<-chan *QueryCopyrightExtractJobResponse, <-chan error) {
	responseChan := make(chan *QueryCopyrightExtractJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCopyrightExtractJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCopyrightExtractJobWithCallback invokes the mts.QueryCopyrightExtractJob API asynchronously
func (client *Client) QueryCopyrightExtractJobWithCallback(request *QueryCopyrightExtractJobRequest, callback func(response *QueryCopyrightExtractJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCopyrightExtractJobResponse
		var err error
		defer close(result)
		response, err = client.QueryCopyrightExtractJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCopyrightExtractJobRequest is the request struct for api QueryCopyrightExtractJob
type QueryCopyrightExtractJobRequest struct {
	*requests.RpcRequest
	JobId string `position:"Query" name:"JobId"`
}

// QueryCopyrightExtractJobResponse is the response struct for api QueryCopyrightExtractJob
type QueryCopyrightExtractJobResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Message    string `json:"Message" xml:"Message"`
	StatusCode int64  `json:"StatusCode" xml:"StatusCode"`
	Data       Data   `json:"Data" xml:"Data"`
}

// CreateQueryCopyrightExtractJobRequest creates a request to invoke QueryCopyrightExtractJob API
func CreateQueryCopyrightExtractJobRequest() (request *QueryCopyrightExtractJobRequest) {
	request = &QueryCopyrightExtractJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QueryCopyrightExtractJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryCopyrightExtractJobResponse creates a response to parse from QueryCopyrightExtractJob response
func CreateQueryCopyrightExtractJobResponse() (response *QueryCopyrightExtractJobResponse) {
	response = &QueryCopyrightExtractJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
