package nlb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSecurityPolicy invokes the nlb.ListSecurityPolicy API synchronously
func (client *Client) ListSecurityPolicy(request *ListSecurityPolicyRequest) (response *ListSecurityPolicyResponse, err error) {
	response = CreateListSecurityPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// ListSecurityPolicyWithChan invokes the nlb.ListSecurityPolicy API asynchronously
func (client *Client) ListSecurityPolicyWithChan(request *ListSecurityPolicyRequest) (<-chan *ListSecurityPolicyResponse, <-chan error) {
	responseChan := make(chan *ListSecurityPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSecurityPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSecurityPolicyWithCallback invokes the nlb.ListSecurityPolicy API asynchronously
func (client *Client) ListSecurityPolicyWithCallback(request *ListSecurityPolicyRequest, callback func(response *ListSecurityPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSecurityPolicyResponse
		var err error
		defer close(result)
		response, err = client.ListSecurityPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSecurityPolicyRequest is the request struct for api ListSecurityPolicy
type ListSecurityPolicyRequest struct {
	*requests.RpcRequest
	SecurityPolicyNames *[]string                `position:"Body" name:"SecurityPolicyNames"  type:"Repeated"`
	ResourceGroupId     string                   `position:"Body" name:"ResourceGroupId"`
	NextToken           string                   `position:"Body" name:"NextToken"`
	Tag                 *[]ListSecurityPolicyTag `position:"Query" name:"Tag"  type:"Repeated"`
	SecurityPolicyIds   *[]string                `position:"Body" name:"SecurityPolicyIds"  type:"Repeated"`
	MaxResults          requests.Integer         `position:"Body" name:"MaxResults"`
}

// ListSecurityPolicyTag is a repeated param struct in ListSecurityPolicyRequest
type ListSecurityPolicyTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// ListSecurityPolicyResponse is the response struct for api ListSecurityPolicy
type ListSecurityPolicyResponse struct {
	*responses.BaseResponse
	RequestId        string            `json:"RequestId" xml:"RequestId"`
	Success          bool              `json:"Success" xml:"Success"`
	Code             string            `json:"Code" xml:"Code"`
	Message          string            `json:"Message" xml:"Message"`
	HttpStatusCode   int               `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicCode      string            `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage   string            `json:"DynamicMessage" xml:"DynamicMessage"`
	TotalCount       int               `json:"TotalCount" xml:"TotalCount"`
	NextToken        string            `json:"NextToken" xml:"NextToken"`
	MaxResults       int               `json:"MaxResults" xml:"MaxResults"`
	SecurityPolicies []SecurityPolicie `json:"SecurityPolicies" xml:"SecurityPolicies"`
}

// CreateListSecurityPolicyRequest creates a request to invoke ListSecurityPolicy API
func CreateListSecurityPolicyRequest() (request *ListSecurityPolicyRequest) {
	request = &ListSecurityPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Nlb", "2022-04-30", "ListSecurityPolicy", "nlb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSecurityPolicyResponse creates a response to parse from ListSecurityPolicy response
func CreateListSecurityPolicyResponse() (response *ListSecurityPolicyResponse) {
	response = &ListSecurityPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
