package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceSecurityConfigs invokes the oceanbasepro.DescribeInstanceSecurityConfigs API synchronously
func (client *Client) DescribeInstanceSecurityConfigs(request *DescribeInstanceSecurityConfigsRequest) (response *DescribeInstanceSecurityConfigsResponse, err error) {
	response = CreateDescribeInstanceSecurityConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceSecurityConfigsWithChan invokes the oceanbasepro.DescribeInstanceSecurityConfigs API asynchronously
func (client *Client) DescribeInstanceSecurityConfigsWithChan(request *DescribeInstanceSecurityConfigsRequest) (<-chan *DescribeInstanceSecurityConfigsResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceSecurityConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceSecurityConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceSecurityConfigsWithCallback invokes the oceanbasepro.DescribeInstanceSecurityConfigs API asynchronously
func (client *Client) DescribeInstanceSecurityConfigsWithCallback(request *DescribeInstanceSecurityConfigsRequest, callback func(response *DescribeInstanceSecurityConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceSecurityConfigsResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceSecurityConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceSecurityConfigsRequest is the request struct for api DescribeInstanceSecurityConfigs
type DescribeInstanceSecurityConfigsRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Body" name:"InstanceId"`
	CheckId    string `position:"Body" name:"CheckId"`
}

// DescribeInstanceSecurityConfigsResponse is the response struct for api DescribeInstanceSecurityConfigs
type DescribeInstanceSecurityConfigsResponse struct {
	*responses.BaseResponse
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	InstanceSecurityConfigs InstanceSecurityConfigs `json:"InstanceSecurityConfigs" xml:"InstanceSecurityConfigs"`
}

// CreateDescribeInstanceSecurityConfigsRequest creates a request to invoke DescribeInstanceSecurityConfigs API
func CreateDescribeInstanceSecurityConfigsRequest() (request *DescribeInstanceSecurityConfigsRequest) {
	request = &DescribeInstanceSecurityConfigsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeInstanceSecurityConfigs", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceSecurityConfigsResponse creates a response to parse from DescribeInstanceSecurityConfigs response
func CreateDescribeInstanceSecurityConfigsResponse() (response *DescribeInstanceSecurityConfigsResponse) {
	response = &DescribeInstanceSecurityConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
