package oms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDomainPartConfig invokes the oms.GetDomainPartConfig API synchronously
func (client *Client) GetDomainPartConfig(request *GetDomainPartConfigRequest) (response *GetDomainPartConfigResponse, err error) {
	response = CreateGetDomainPartConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetDomainPartConfigWithChan invokes the oms.GetDomainPartConfig API asynchronously
func (client *Client) GetDomainPartConfigWithChan(request *GetDomainPartConfigRequest) (<-chan *GetDomainPartConfigResponse, <-chan error) {
	responseChan := make(chan *GetDomainPartConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDomainPartConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDomainPartConfigWithCallback invokes the oms.GetDomainPartConfig API asynchronously
func (client *Client) GetDomainPartConfigWithCallback(request *GetDomainPartConfigRequest, callback func(response *GetDomainPartConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDomainPartConfigResponse
		var err error
		defer close(result)
		response, err = client.GetDomainPartConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDomainPartConfigRequest is the request struct for api GetDomainPartConfig
type GetDomainPartConfigRequest struct {
	*requests.RpcRequest
	DomainCode     string           `position:"Query" name:"DomainCode"`
	DataType       string           `position:"Query" name:"DataType"`
	CompressEnable requests.Boolean `position:"Query" name:"CompressEnable"`
	Part           string           `position:"Query" name:"Part"`
}

// GetDomainPartConfigResponse is the response struct for api GetDomainPartConfig
type GetDomainPartConfigResponse struct {
	*responses.BaseResponse
	Compressed bool   `json:"Compressed" xml:"Compressed"`
	Data       string `json:"Data" xml:"Data"`
	DataType   string `json:"DataType" xml:"DataType"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	DomainCode string `json:"DomainCode" xml:"DomainCode"`
}

// CreateGetDomainPartConfigRequest creates a request to invoke GetDomainPartConfig API
func CreateGetDomainPartConfigRequest() (request *GetDomainPartConfigRequest) {
	request = &GetDomainPartConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oms", "2016-06-15", "GetDomainPartConfig", "", "")
	request.Method = requests.GET
	return
}

// CreateGetDomainPartConfigResponse creates a response to parse from GetDomainPartConfig response
func CreateGetDomainPartConfigResponse() (response *GetDomainPartConfigResponse) {
	response = &GetDomainPartConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
