package oms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOpenApiConfig invokes the oms.GetOpenApiConfig API synchronously
func (client *Client) GetOpenApiConfig(request *GetOpenApiConfigRequest) (response *GetOpenApiConfigResponse, err error) {
	response = CreateGetOpenApiConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetOpenApiConfigWithChan invokes the oms.GetOpenApiConfig API asynchronously
func (client *Client) GetOpenApiConfigWithChan(request *GetOpenApiConfigRequest) (<-chan *GetOpenApiConfigResponse, <-chan error) {
	responseChan := make(chan *GetOpenApiConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOpenApiConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOpenApiConfigWithCallback invokes the oms.GetOpenApiConfig API asynchronously
func (client *Client) GetOpenApiConfigWithCallback(request *GetOpenApiConfigRequest, callback func(response *GetOpenApiConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOpenApiConfigResponse
		var err error
		defer close(result)
		response, err = client.GetOpenApiConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOpenApiConfigRequest is the request struct for api GetOpenApiConfig
type GetOpenApiConfigRequest struct {
	*requests.RpcRequest
	DataType       string           `position:"Query" name:"DataType"`
	CompressEnable requests.Boolean `position:"Query" name:"CompressEnable"`
	ProductName    string           `position:"Query" name:"ProductName"`
	TableName      string           `position:"Query" name:"TableName"`
	SiteBid        string           `position:"Query" name:"siteBid"`
}

// GetOpenApiConfigResponse is the response struct for api GetOpenApiConfig
type GetOpenApiConfigResponse struct {
	*responses.BaseResponse
	TableName   string `json:"TableName" xml:"TableName"`
	DataType    string `json:"DataType" xml:"DataType"`
	Data        string `json:"Data" xml:"Data"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	ProductName string `json:"ProductName" xml:"ProductName"`
	Compressed  bool   `json:"Compressed" xml:"Compressed"`
	SiteBid     string `json:"SiteBid" xml:"SiteBid"`
}

// CreateGetOpenApiConfigRequest creates a request to invoke GetOpenApiConfig API
func CreateGetOpenApiConfigRequest() (request *GetOpenApiConfigRequest) {
	request = &GetOpenApiConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oms", "2016-06-15", "GetOpenApiConfig", "", "")
	request.Method = requests.GET
	return
}

// CreateGetOpenApiConfigResponse creates a response to parse from GetOpenApiConfig response
func CreateGetOpenApiConfigResponse() (response *GetOpenApiConfigResponse) {
	response = &GetOpenApiConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
