package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSecretParameter invokes the oos.CreateSecretParameter API synchronously
func (client *Client) CreateSecretParameter(request *CreateSecretParameterRequest) (response *CreateSecretParameterResponse, err error) {
	response = CreateCreateSecretParameterResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSecretParameterWithChan invokes the oos.CreateSecretParameter API asynchronously
func (client *Client) CreateSecretParameterWithChan(request *CreateSecretParameterRequest) (<-chan *CreateSecretParameterResponse, <-chan error) {
	responseChan := make(chan *CreateSecretParameterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSecretParameter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSecretParameterWithCallback invokes the oos.CreateSecretParameter API asynchronously
func (client *Client) CreateSecretParameterWithCallback(request *CreateSecretParameterRequest, callback func(response *CreateSecretParameterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSecretParameterResponse
		var err error
		defer close(result)
		response, err = client.CreateSecretParameter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSecretParameterRequest is the request struct for api CreateSecretParameter
type CreateSecretParameterRequest struct {
	*requests.RpcRequest
	ClientToken     string            `position:"Query" name:"ClientToken"`
	Description     string            `position:"Query" name:"Description"`
	Type            string            `position:"Query" name:"Type"`
	Constraints     string            `position:"Query" name:"Constraints"`
	ResourceGroupId string            `position:"Query" name:"ResourceGroupId"`
	Value           string            `position:"Query" name:"Value"`
	KeyId           string            `position:"Query" name:"KeyId"`
	Tags            map[string]string `position:"Query" name:"Tags"  type:"Map"`
	Name            string            `position:"Query" name:"Name"`
}

// CreateSecretParameterResponse is the response struct for api CreateSecretParameter
type CreateSecretParameterResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Parameter Parameter `json:"Parameter" xml:"Parameter"`
}

// CreateCreateSecretParameterRequest creates a request to invoke CreateSecretParameter API
func CreateCreateSecretParameterRequest() (request *CreateSecretParameterRequest) {
	request = &CreateSecretParameterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "CreateSecretParameter", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSecretParameterResponse creates a response to parse from CreateSecretParameter response
func CreateCreateSecretParameterResponse() (response *CreateSecretParameterResponse) {
	response = &CreateSecretParameterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
