package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveSortScriptFile invokes the opensearch.SaveSortScriptFile API synchronously
func (client *Client) SaveSortScriptFile(request *SaveSortScriptFileRequest) (response *SaveSortScriptFileResponse, err error) {
	response = CreateSaveSortScriptFileResponse()
	err = client.DoAction(request, response)
	return
}

// SaveSortScriptFileWithChan invokes the opensearch.SaveSortScriptFile API asynchronously
func (client *Client) SaveSortScriptFileWithChan(request *SaveSortScriptFileRequest) (<-chan *SaveSortScriptFileResponse, <-chan error) {
	responseChan := make(chan *SaveSortScriptFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveSortScriptFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveSortScriptFileWithCallback invokes the opensearch.SaveSortScriptFile API asynchronously
func (client *Client) SaveSortScriptFileWithCallback(request *SaveSortScriptFileRequest, callback func(response *SaveSortScriptFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveSortScriptFileResponse
		var err error
		defer close(result)
		response, err = client.SaveSortScriptFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveSortScriptFileRequest is the request struct for api SaveSortScriptFile
type SaveSortScriptFileRequest struct {
	*requests.RoaRequest
	AppVersionId     string `position:"Path" name:"appVersionId"`
	FileName         string `position:"Path" name:"fileName"`
	ScriptName       string `position:"Path" name:"scriptName"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// SaveSortScriptFileResponse is the response struct for api SaveSortScriptFile
type SaveSortScriptFileResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateSaveSortScriptFileRequest creates a request to invoke SaveSortScriptFile API
func CreateSaveSortScriptFileRequest() (request *SaveSortScriptFileRequest) {
	request = &SaveSortScriptFileRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "SaveSortScriptFile", "/v4/openapi/app-groups/[appGroupIdentity]/apps/[appVersionId]/sort-scripts/[scriptName]/files/src/[fileName]", "", "")
	request.Method = requests.PUT
	return
}

// CreateSaveSortScriptFileResponse creates a response to parse from SaveSortScriptFile response
func CreateSaveSortScriptFileResponse() (response *SaveSortScriptFileResponse) {
	response = &SaveSortScriptFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
